/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.DOMImplementation;

public abstract class AbstractDOMImplementation
implements DOMImplementation,
Serializable {
    protected final HashTable features = new HashTable();

    protected void registerFeature(String name, Object value) {
        this.features.put(name.toLowerCase(), value);
    }

    protected AbstractDOMImplementation() {
        this.registerFeature("XML", new String[]{"1.0", "2.0"});
        this.registerFeature("Events", "2.0");
        this.registerFeature("MouseEvents", "2.0");
        this.registerFeature("MutationEvents", "2.0");
        this.registerFeature("Traversal", "2.0");
        this.registerFeature("UIEvents", "2.0");
    }

    public boolean hasFeature(String feature, String version) {
        Object v = this.features.get(feature.toLowerCase());
        if (v == null) {
            return false;
        }
        if (version == null || version.length() == 0) {
            return true;
        }
        if (v instanceof String) {
            return version.equals(v);
        }
        String[] va = (String[])v;
        int i = 0;
        while (i < va.length) {
            if (version.equals(va[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public DocumentEventSupport createDocumentEventSupport() {
        return new DocumentEventSupport();
    }
}

