/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.CustomCopy;
import com.arsdigita.cms.ItemCopier;
import com.arsdigita.cms.contenttypes.DecisionTreeOptionTarget;
import com.arsdigita.cms.contenttypes.DecisionTreeOptionTargetCollection;
import com.arsdigita.cms.contenttypes.DecisionTreeSection;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionCollection;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionOptionCollection;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.cms.dispatcher.XMLGenerator;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class DecisionTree
extends ContentPage
implements XMLGenerator {
    public static final Logger s_log = Logger.getLogger(DecisionTree.class);
    public static final String ADAPTER_CONTEXT = SimpleXMLGenerator.class.getName();
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.DecisionTree";
    public static final String CANCEL_URL = "cancelURL";
    public static final String PARAM_RETURN_URL = "return_url";
    public static final String FIRST_SECTION = "firstSection";
    public static final String SECTIONS = "sections";
    public static final String PARAM_SECTION_ID = "section_id";
    public static final String PARAM_SECTION_OID = "section_oid";
    public static final String BUTTON_CANCEL = "cancel";
    public static final String BUTTON_NEXT = "next";

    public DecisionTree() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public DecisionTree(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public DecisionTree(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public DecisionTree(DataObject obj) {
        super(obj);
    }

    public DecisionTree(String type) {
        super(type);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getCancelURL() {
        return (String)this.get(CANCEL_URL);
    }

    public void setCancelURL(String value) {
        this.set(CANCEL_URL, value);
    }

    public DecisionTreeSection getFirstSection() {
        DataObject dataObject = (DataObject)this.get(FIRST_SECTION);
        if (dataObject == null) {
            return null;
        }
        return new DecisionTreeSection(dataObject);
    }

    public void setFirstSection(DecisionTreeSection value) {
        this.setAssociation(FIRST_SECTION, (DomainObject)value);
    }

    public void addSection(DecisionTreeSection section) {
        DecisionTreeSectionCollection sections = this.getSections();
        boolean isFirst = sections.isEmpty();
        this.add(SECTIONS, (DomainObject)section);
        if (isFirst) {
            this.setFirstSection(section);
        }
    }

    public DecisionTreeSectionCollection getSections() {
        DecisionTreeSectionCollection sections = new DecisionTreeSectionCollection((DataCollection)this.get(SECTIONS));
        sections.addOrder("title");
        return sections;
    }

    public void removeSection(DecisionTreeSection section) {
        section.delete();
    }

    public DecisionTreeSectionOptionCollection getOptions() {
        Session ssn = SessionManager.getSession();
        DataCollection collection = ssn.retrieve("com.arsdigita.cms.contenttypes.DecisionTreeSectionOption");
        DecisionTreeSectionOptionCollection options = new DecisionTreeSectionOptionCollection(collection);
        options.addEqualsFilter("treeSection.tree.id", this.getID());
        options.addOrder("treeSection.title, rank, label");
        return options;
    }

    public DecisionTreeOptionTargetCollection getTargets() {
        Session ssn = SessionManager.getSession();
        DataCollection collection = ssn.retrieve("com.arsdigita.cms.contenttypes.DecisionTreeOptionTarget");
        DecisionTreeOptionTargetCollection options = new DecisionTreeOptionTargetCollection(collection);
        options.addEqualsFilter("matchOption.treeSection.tree.id", this.getID());
        options.addOrder("matchOption.treeSection.title, matchOption.rank, matchOption.label");
        return options;
    }

    public static boolean preserveParameter(String parameterName) {
        return !PARAM_SECTION_ID.equals(parameterName) && !PARAM_SECTION_OID.equals(parameterName) && !PARAM_RETURN_URL.equals(parameterName) && !BUTTON_CANCEL.equals(parameterName) && !BUTTON_NEXT.equals(parameterName) && !"app-id".equals(parameterName);
    }

    public void generateXML(PageState state, Element parent, String useContext) {
        ContentItem item = CMS.getContext().getContentItem();
        Element content = new Element("cms:item", "http://www.arsdigita.com/cms/1.0");
        if (useContext != null) {
            content.addAttribute("useContext", useContext);
        }
        Element customInfo = new Element("customInfo");
        customInfo.addAttribute("currentURL", state.getRequestURI());
        content.addContent(customInfo);
        HttpServletRequest request = state.getRequest();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            if (!DecisionTree.preserveParameter(name)) continue;
            Element parameters = new Element("parameters");
            parameters.addAttribute("name", name);
            parameters.addAttribute("value", request.getParameter(name));
            content.addContent(parameters);
        }
        DomainObjectXMLRenderer renderer = new DomainObjectXMLRenderer(content);
        renderer.setWrapAttributes(true);
        renderer.setWrapRoot(false);
        renderer.setWrapObjects(false);
        renderer.setRevisitFullObject(true);
        renderer.walk((DomainObject)item, ADAPTER_CONTEXT);
        parent.addContent(content);
    }

    public boolean copyProperty(CustomCopy source, Property property, ItemCopier copier) {
        String attribute = property.getName();
        if (FIRST_SECTION.equals(attribute)) {
            return true;
        }
        if (SECTIONS.equals(attribute)) {
            DecisionTree srcTree = (DecisionTree)source;
            DecisionTreeSectionCollection srcSections = srcTree.getSections();
            while (srcSections.next()) {
                copier.copy(source, (CustomCopy)this, (DomainObject)srcSections.getSection(), property);
            }
            DecisionTreeSection srcFirstSection = srcTree.getFirstSection();
            if (srcFirstSection != null) {
                this.setFirstSection((DecisionTreeSection)copier.getCopy(srcFirstSection.getOID()));
            }
            DecisionTreeOptionTargetCollection srcTargets = srcTree.getTargets();
            while (srcTargets.next()) {
                DecisionTreeOptionTarget srcTarget = srcTargets.getTarget();
                DecisionTreeSection srcSection = srcTarget.getTargetSection();
                if (srcSection == null) continue;
                DecisionTreeOptionTarget dstTarget = (DecisionTreeOptionTarget)copier.getCopy(srcTarget.getOID());
                dstTarget.setTargetSection((DecisionTreeSection)copier.getCopy(srcSection.getOID()));
            }
        }
        return super.copyProperty(source, property, copier);
    }
}

