/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.contenttypes.DecisionTree;
import com.arsdigita.cms.contenttypes.DecisionTreeOptionTargetCollection;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionOption;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionOptionCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class DecisionTreeSection
extends ContentPage {
    public static final Logger s_log = Logger.getLogger(DecisionTreeSection.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.DecisionTreeSection";
    public static final String PARAMETER_NAME = "parameterName";
    public static final String INSTRUCTIONS = "instructions";
    public static final String SECTION_OPTIONS = "sectionOptions";
    public static final String TREE = "tree";

    public DecisionTreeSection() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public DecisionTreeSection(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public DecisionTreeSection(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public DecisionTreeSection(DataObject obj) {
        super(obj);
    }

    public DecisionTreeSection(String type) {
        super(type);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected void beforeDelete() {
        super.beforeDelete();
        DecisionTree tree = this.getTree();
        if (this.equals((Object)tree.getFirstSection())) {
            tree.setFirstSection(null);
        }
        DecisionTreeOptionTargetCollection targets = tree.getTargets();
        targets.addEqualsFilter("targetSection.id", this.getID());
        while (targets.next()) {
            targets.getTarget().delete();
        }
    }

    public String getParameterName() {
        return (String)this.get(PARAMETER_NAME);
    }

    public void setParameterName(String value) {
        this.set(PARAMETER_NAME, value);
    }

    public TextAsset getInstructions() {
        DataObject dataObject = (DataObject)this.get(INSTRUCTIONS);
        if (dataObject == null) {
            return null;
        }
        return new TextAsset(dataObject);
    }

    public void setInstructions(TextAsset value) {
        this.setAssociation(INSTRUCTIONS, (DomainObject)value);
    }

    public DecisionTreeSectionOptionCollection getOptions() {
        return new DecisionTreeSectionOptionCollection((DataCollection)this.get(SECTION_OPTIONS));
    }

    public DecisionTree getTree() {
        return new DecisionTree((DataObject)this.get(TREE));
    }

    public int getMaxOptionRank() {
        DecisionTreeSectionOptionCollection options = this.getOptions();
        options.addOrder("rank desc");
        int maxRank = 0;
        if (options.next()) {
            maxRank = options.getOption().getRank();
        }
        options.close();
        return maxRank;
    }

    public void changeOptionRank(DecisionTreeSectionOption source, int destRank) {
        Integer r = source.getRank();
        if (r == null) {
            throw new IllegalStateException((Object)((Object)source) + " has null rank");
        }
        int curRank = r;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("*** changeSectionRank, section ID = " + source.getID() + ", curRank = " + curRank + ", destRank = " + destRank));
        }
        DecisionTreeSectionOptionCollection coll = this.getOptions();
        coll.addOrder("rank");
        if (curRank > destRank) {
            coll.setRange(new Integer(destRank), new Integer(curRank));
            int rank = destRank;
            while (coll.next()) {
                DecisionTreeSectionOption cur = coll.getOption();
                cur.setRank(new Integer(rank + 1));
                cur.save();
                ++rank;
            }
            source.setRank(new Integer(destRank));
        } else if (curRank < destRank) {
            coll.setRange(new Integer(curRank + 1), new Integer(destRank + 1));
            int rank = curRank + 1;
            while (coll.next()) {
                DecisionTreeSectionOption cur = coll.getOption();
                cur.setRank(new Integer(rank - 1));
                cur.save();
                ++rank;
            }
            source.setRank(new Integer(destRank));
        }
        coll.close();
    }
}

