/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.contenttypes.ContentItemTraversalAdapter;
import com.arsdigita.cms.contenttypes.DecisionTree;
import com.arsdigita.cms.contenttypes.DecisionTreeSection;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.SimpleDomainObjectTraversalAdapter;
import com.arsdigita.persistence.metadata.Property;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class DecisionTreeTraversalAdapter
extends ContentItemTraversalAdapter {
    private static final Logger s_log = Logger.getLogger(DecisionTreeTraversalAdapter.class);

    public DecisionTreeTraversalAdapter() {
    }

    public DecisionTreeTraversalAdapter(SimpleDomainObjectTraversalAdapter adapter) {
        super(adapter);
    }

    public boolean processProperty(DomainObject obj, String path, Property prop, String context) {
        HttpServletRequest request = DispatcherHelper.getRequest();
        if ("/object/sections/title".equals(path) || "/object/sections/instructions".equals(path) || "/object/sections/sectionOptions".equals(path)) {
            DecisionTreeSection section = (DecisionTreeSection)obj;
            DecisionTreeSection selectedSection = null;
            String sectionID = request.getParameter("section_id");
            if (sectionID == null || "".equals(sectionID)) {
                DecisionTree tree = section.getTree();
                selectedSection = tree.getFirstSection();
                if (selectedSection == null) {
                    throw new RuntimeException("The first section has not been set for tree " + (Object)((Object)tree));
                }
            } else {
                try {
                    selectedSection = new DecisionTreeSection(new BigDecimal(sectionID));
                }
                catch (DataObjectNotFoundException e) {
                    throw new RuntimeException("Cannot find section for section_id parameter " + sectionID);
                }
            }
            return section.equals((Object)selectedSection);
        }
        return super.processProperty(obj, path, prop, context);
    }
}

