/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionOption;
import com.arsdigita.cms.contenttypes.util.DecisionTreeGlobalizationUtil;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class DecisionTreeOptionDeleteForm
extends Form
implements FormInitListener,
FormSubmissionListener,
FormProcessListener {
    private static final Logger s_log = Logger.getLogger((String)DecisionTreeOptionDeleteForm.class.getName());
    protected ItemSelectionModel m_selTree;
    protected ItemSelectionModel m_selOption;
    protected SaveCancelSection m_saveCancelSection;
    private Label optionLabel;
    private String[] optionValue = new String[1];

    public DecisionTreeOptionDeleteForm(ItemSelectionModel selTree, ItemSelectionModel selOption) {
        super("DecisionTreeOptionDeleteForm", (Container)new ColumnPanel(2));
        this.m_selTree = selTree;
        this.m_selOption = selOption;
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
        panel.setWidth("100%");
        this.optionLabel = new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.delete_option_msg", this.optionValue));
        this.add((Component)this.optionLabel, 65);
        this.addSaveCancelSection();
        this.addInitListener(this);
        this.addSubmissionListener(this);
        this.addProcessListener(this);
    }

    protected SaveCancelSection addSaveCancelSection() {
        this.m_saveCancelSection = new SaveCancelSection();
        this.m_saveCancelSection.getSaveButton().setButtonLabel(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.delete_button"));
        this.add((Component)this.m_saveCancelSection, 65);
        return this.m_saveCancelSection;
    }

    public void init(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        BigDecimal id = new BigDecimal(this.m_selOption.getSelectedKey(state).toString());
        DecisionTreeSectionOption option = new DecisionTreeSectionOption(id);
        this.optionValue[0] = option.getLabel();
    }

    public void submitted(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        if (this.m_saveCancelSection.getCancelButton().isSelected(state)) {
            throw new FormProcessException((String)DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.delete.submission_cancelled").localize());
        }
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        BigDecimal id = new BigDecimal(this.m_selOption.getSelectedKey(state).toString());
        DecisionTreeSectionOption option = new DecisionTreeSectionOption(id);
        option.delete();
    }
}

