/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.DecisionTree;
import com.arsdigita.cms.contenttypes.DecisionTreeSection;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionCollection;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionOption;
import com.arsdigita.cms.contenttypes.ui.DecisionTreeOptionStep;
import com.arsdigita.cms.contenttypes.util.DecisionTreeGlobalizationUtil;
import java.math.BigDecimal;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class DecisionTreeOptionEditForm
extends Form
implements FormInitListener,
FormProcessListener,
FormSubmissionListener {
    private static final Logger s_log = Logger.getLogger(DecisionTreeOptionEditForm.class);
    private ItemSelectionModel m_selTree;
    private ItemSelectionModel m_selOption;
    private DecisionTreeOptionStep m_container;
    private SaveCancelSection m_saveCancelSection;
    private SingleSelect m_sectionWidget;
    public static final String LABEL = "label";
    public static final String VALUE = "value";
    public static final String SECTION = "section";

    public DecisionTreeOptionEditForm(ItemSelectionModel selTree, ItemSelectionModel selOption) {
        this(selTree, selOption, null);
    }

    public DecisionTreeOptionEditForm(ItemSelectionModel selTree, ItemSelectionModel selOption, DecisionTreeOptionStep container) {
        super("DecisionTreeOptionEditForm", (Container)new ColumnPanel(2));
        this.m_selTree = selTree;
        this.m_selOption = selOption;
        this.m_container = container;
        this.setMethod("post");
        this.setEncType("multipart/form-data");
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
        panel.setWidth("100%");
        this.addWidgets();
        this.addSaveCancelSection();
        this.addInitListener(this);
        this.addSubmissionListener(this);
        this.addProcessListener(this);
    }

    protected SaveCancelSection addSaveCancelSection() {
        this.m_saveCancelSection = new SaveCancelSection();
        this.add((Component)this.m_saveCancelSection, 65);
        return this.m_saveCancelSection;
    }

    public SaveCancelSection getSaveCancelSection() {
        return this.m_saveCancelSection;
    }

    private void initSectionOptions(PrintEvent e) {
        DecisionTreeSectionCollection sections;
        PageState state = e.getPageState();
        SingleSelect target = (SingleSelect)e.getTarget();
        DecisionTree tree = (DecisionTree)this.m_selTree.getSelectedObject(state);
        if (tree != null && (sections = tree.getSections()) != null) {
            while (sections.next()) {
                DecisionTreeSection section = sections.getSection();
                Option option = new Option(section.getID().toString(), section.getTitle());
                target.addOption(option, state);
            }
            sections.close();
        }
    }

    public void init(FormSectionEvent fse) {
        PageState state = fse.getPageState();
        FormData data = fse.getFormData();
        if (this.m_selOption.getSelectedKey(state) != null) {
            BigDecimal id = new BigDecimal(this.m_selOption.getSelectedKey(state).toString());
            DecisionTreeSectionOption sectionOption = new DecisionTreeSectionOption(id);
            data.put((Object)SECTION, (Object)sectionOption.getSection().getID());
            data.put((Object)LABEL, (Object)sectionOption.getLabel());
            data.put((Object)VALUE, (Object)sectionOption.getValue());
        }
    }

    protected void addWidgets() {
        Option pleaseSelect = new Option("", (Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.form.please_select")));
        this.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.form.section")));
        this.m_sectionWidget = new SingleSelect(SECTION);
        this.m_sectionWidget.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_sectionWidget.addOption(pleaseSelect);
        try {
            this.m_sectionWidget.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    DecisionTreeOptionEditForm.this.initSectionOptions(e);
                }
            });
        }
        catch (TooManyListenersException e) {
            throw new RuntimeException(e);
        }
        this.add((Component)this.m_sectionWidget);
        this.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.form.label")));
        TextField labelWidget = new TextField((ParameterModel)new TrimmedStringParameter(LABEL));
        labelWidget.addValidationListener((ParameterListener)new NotNullValidationListener());
        labelWidget.setSize(60);
        this.add((Component)labelWidget);
        this.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.form.value")));
        TextField valueWidget = new TextField((ParameterModel)new TrimmedStringParameter(VALUE));
        valueWidget.addValidationListener((ParameterListener)new NotNullValidationListener());
        valueWidget.setSize(60);
        this.add((Component)valueWidget);
    }

    public void submitted(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        if (this.m_saveCancelSection.getCancelButton().isSelected(state) && this.m_container != null) {
            this.m_container.onlyShowComponent(state, "opt_tbl" + this.m_container.getTypeIDStr());
            throw new FormProcessException((String)DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.form.submission_cancelled").localize());
        }
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        FormData data = event.getFormData();
        DecisionTreeSection section = new DecisionTreeSection(new BigDecimal((String)data.get((Object)SECTION)));
        DecisionTreeSectionOption option = null;
        if (this.m_selOption.getSelectedKey(state) != null) {
            BigDecimal id = new BigDecimal(this.m_selOption.getSelectedKey(state).toString());
            option = new DecisionTreeSectionOption(id);
        } else {
            option = new DecisionTreeSectionOption();
            option.setName("DecisionTreeSectionOption " + option.getID());
            int rank = section.getMaxOptionRank() + 1;
            option.setRank(rank);
        }
        String label = (String)data.get((Object)LABEL);
        String value = (String)data.get((Object)VALUE);
        option.setSection(section);
        option.setLabel(label);
        option.setValue(value);
        if (this.m_container != null) {
            this.m_container.onlyShowComponent(state, "opt_tbl" + this.m_container.getTypeIDStr());
        }
    }

    public void register(Page p) {
        super.register(p);
    }
}

