/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionOption;
import com.arsdigita.cms.contenttypes.ui.DecisionTreeOptionDeleteForm;
import com.arsdigita.cms.contenttypes.ui.DecisionTreeOptionEditForm;
import com.arsdigita.cms.contenttypes.ui.DecisionTreeOptionTable;
import com.arsdigita.cms.contenttypes.ui.ResettableContainer;
import com.arsdigita.cms.contenttypes.util.DecisionTreeGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class DecisionTreeOptionStep
extends ResettableContainer {
    public static final String OPTION_TABLE = "opt_tbl";
    public static final String OPTION_EDIT = "opt_edt";
    public static final String OPTION_DEL = "opt_del";
    public static final String DATA_TABLE = "dataTable";
    public static final String ACTION_LINK = "actionLink";
    protected AuthoringKitWizard m_wizard;
    protected ItemSelectionModel m_selTree;
    protected ItemSelectionModel m_selOption;
    protected ItemSelectionModel m_moveOption;
    protected BigDecimalParameter m_moveParameter;
    protected DecisionTreeOptionTable m_optionTable;
    protected DecisionTreeOptionEditForm m_optionEdit;
    protected DecisionTreeOptionDeleteForm m_optionDelete;
    protected ActionLink m_beginLink;
    private Label m_moveOptionLabel;
    private String m_typeIDStr;

    public DecisionTreeOptionStep(ItemSelectionModel selTree, AuthoringKitWizard wizard) {
        this.m_selTree = selTree;
        this.m_wizard = wizard;
        this.m_typeIDStr = wizard.getContentType().getID().toString();
        Assert.exists((Object)this.m_selTree, ItemSelectionModel.class);
        this.add((Component)this.buildOptionTable(), true);
        this.add((Component)this.buildOptionEdit(), false);
        this.add((Component)this.buildOptionDelete(), false);
    }

    protected Container buildOptionTable() {
        ColumnPanel c = new ColumnPanel(1);
        c.setKey(OPTION_TABLE + this.m_typeIDStr);
        c.setBorderColor("#FFFFFF");
        c.setPadColor("#FFFFFF");
        final ActionLink addOptionLink = this.buildAddLink();
        this.m_moveParameter = new BigDecimalParameter("moveOption");
        this.m_moveOption = new ItemSelectionModel(DecisionTreeSectionOption.class.getName(), "com.arsdigita.cms.contenttypes.DecisionTreeSectionOption", this.m_moveParameter);
        this.m_optionTable = new DecisionTreeOptionTable(this.m_selTree, this.m_moveOption);
        this.m_optionTable.setClassAttr(DATA_TABLE);
        this.m_selOption = new ItemSelectionModel(DecisionTreeSectionOption.class.getName(), "com.arsdigita.cms.contenttypes.DecisionTreeSectionOption", this.m_optionTable.getRowSelectionModel());
        this.m_optionTable.setOptionModel(this.m_selOption);
        Label emptyView = new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.none_yet"));
        this.m_optionTable.setEmptyView((Component)emptyView);
        this.m_moveOptionLabel = new Label();
        c.add((Component)this.m_moveOptionLabel, 65);
        this.m_beginLink = new ActionLink(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.table.move_to_beginning"));
        c.add((Component)this.m_beginLink);
        this.m_beginLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                DecisionTreeSectionOption option = new DecisionTreeSectionOption((BigDecimal)DecisionTreeOptionStep.this.m_moveOption.getSelectedKey(state));
                option.getSection().changeOptionRank(option, 1);
                option.save();
                DecisionTreeOptionStep.this.m_moveOption.setSelectedKey(state, null);
            }
        });
        this.m_moveOption.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState state = e.getPageState();
                if (DecisionTreeOptionStep.this.m_moveOption.getSelectedKey(state) == null) {
                    DecisionTreeOptionStep.this.m_beginLink.setVisible(state, false);
                    DecisionTreeOptionStep.this.m_moveOptionLabel.setVisible(state, false);
                    addOptionLink.setVisible(state, true);
                } else {
                    DecisionTreeOptionStep.this.m_beginLink.setVisible(state, true);
                    DecisionTreeOptionStep.this.m_moveOptionLabel.setVisible(state, true);
                    addOptionLink.setVisible(state, false);
                    DecisionTreeSectionOption option = (DecisionTreeSectionOption)DecisionTreeOptionStep.this.m_moveOption.getSelectedObject(state);
                    String optionName = option.getSection().getTitle() + " - " + option.getLabel();
                    Object[] moveOptionValues = new String[]{" \"" + optionName + "\""};
                    DecisionTreeOptionStep.this.m_moveOptionLabel.setLabel(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.table.move_option_name", moveOptionValues), state);
                }
            }
        });
        this.m_optionTable.addTableActionListener(new TableActionListener(){

            public void cellSelected(TableActionEvent event) {
                PageState state = event.getPageState();
                int col = event.getColumn();
                if (col == 4) {
                    DecisionTreeOptionStep.this.onlyShowComponent(state, DecisionTreeOptionStep.OPTION_DEL + DecisionTreeOptionStep.this.m_typeIDStr);
                } else if (col == 2) {
                    DecisionTreeOptionStep.this.onlyShowComponent(state, DecisionTreeOptionStep.OPTION_EDIT + DecisionTreeOptionStep.this.m_typeIDStr);
                }
            }

            public void headSelected(TableActionEvent e) {
            }
        });
        c.add((Component)this.m_optionTable);
        c.add((Component)addOptionLink);
        return c;
    }

    protected Container buildOptionEdit() {
        ColumnPanel c = new ColumnPanel(1);
        c.setKey(OPTION_EDIT + this.m_typeIDStr);
        c.setBorderColor("#FFFFFF");
        c.setPadColor("#FFFFFF");
        c.add((Component)new Label(new PrintListener(){

            public void prepare(PrintEvent event) {
                PageState state = event.getPageState();
                Label label = (Label)event.getTarget();
                if (DecisionTreeOptionStep.this.m_selOption.getSelectedKey(state) == null) {
                    label.setLabel(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.add"));
                } else {
                    label.setLabel(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.edit"));
                }
            }
        }));
        this.m_optionEdit = new DecisionTreeOptionEditForm(this.m_selTree, this.m_selOption, this);
        c.add((Component)this.m_optionEdit);
        c.add((Component)this.buildViewAllLink());
        c.add((Component)this.buildAddLink());
        return c;
    }

    protected Container buildOptionDelete() {
        ColumnPanel c = new ColumnPanel(1);
        c.setKey(OPTION_DEL + this.m_typeIDStr);
        c.setBorderColor("#FFFFFF");
        c.setPadColor("#FFFFFF");
        c.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.delete")));
        this.m_optionDelete = new DecisionTreeOptionDeleteForm(this.m_selTree, this.m_selOption);
        this.m_optionDelete.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent e) {
                PageState state = e.getPageState();
                DecisionTreeOptionStep.this.onlyShowComponent(state, DecisionTreeOptionStep.OPTION_TABLE + DecisionTreeOptionStep.this.m_typeIDStr);
            }
        });
        c.add((Component)this.m_optionDelete);
        c.add((Component)this.buildViewAllLink());
        return c;
    }

    protected ActionLink buildViewAllLink() {
        ActionLink viewAllLink = new ActionLink(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.view_all"));
        viewAllLink.setClassAttr(ACTION_LINK);
        viewAllLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DecisionTreeOptionStep.this.onlyShowComponent(event.getPageState(), DecisionTreeOptionStep.OPTION_TABLE + DecisionTreeOptionStep.this.m_typeIDStr);
            }
        });
        return viewAllLink;
    }

    protected ActionLink buildAddLink() {
        ActionLink addLink = new ActionLink(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.add_new")){

            public boolean isVisible(PageState state) {
                SecurityManager sm = CMS.getSecurityManager((PageState)state);
                ContentItem item = (ContentItem)DecisionTreeOptionStep.this.m_selTree.getSelectedObject(state);
                return super.isVisible(state) && sm.canAccess(state.getRequest(), "edit_item", item);
            }
        };
        addLink.setClassAttr(ACTION_LINK);
        addLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                DecisionTreeOptionStep.this.m_selOption.clearSelection(state);
                DecisionTreeOptionStep.this.onlyShowComponent(state, DecisionTreeOptionStep.OPTION_EDIT + DecisionTreeOptionStep.this.m_typeIDStr);
            }
        });
        return addLink;
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_moveParameter);
        p.setVisibleDefault((Component)this.m_beginLink, false);
        p.setVisibleDefault((Component)this.m_moveOptionLabel, false);
    }

    public String getTypeIDStr() {
        return this.m_typeIDStr;
    }
}

