/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.DecisionTree;
import com.arsdigita.cms.contenttypes.DecisionTreeSection;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionOption;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionOptionCollection;
import com.arsdigita.cms.contenttypes.util.DecisionTreeGlobalizationUtil;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class DecisionTreeOptionTable
extends Table {
    public static final int COL_IDX_SECTION = 0;
    public static final int COL_IDX_OPTION = 1;
    public static final int COL_IDX_EDIT = 2;
    public static final int COL_IDX_MOVE = 3;
    public static final int COL_IDX_DEL = 4;
    private ItemSelectionModel m_selTree;
    private ItemSelectionModel m_selOption;
    private ItemSelectionModel m_moveOption;
    private static final Logger s_log = Logger.getLogger(DecisionTreeOptionTable.class);

    public DecisionTreeOptionTable(ItemSelectionModel selTree, ItemSelectionModel moveOption) {
        this.m_selTree = selTree;
        this.m_moveOption = moveOption;
        TableColumnModel model = this.getColumnModel();
        model.add(new TableColumn(0, (Object)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.table.header_section"))));
        model.add(new TableColumn(1, (Object)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.table.header_option"))));
        model.add(new TableColumn(2, (Object)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.table.header_edit"))));
        model.add(new TableColumn(3, (Object)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.table.header_move"))));
        model.add(new TableColumn(4, (Object)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.table.header_delete"))));
        model.get(2).setCellRenderer((TableCellRenderer)new SectionTableCellRenderer(true));
        model.get(3).setCellRenderer((TableCellRenderer)new SectionTableCellRenderer(true));
        model.get(4).setCellRenderer((TableCellRenderer)new SectionTableCellRenderer(true));
        this.setModelBuilder(new OptionTableModelBuilder(this.m_selTree, this.m_moveOption));
        this.addTableActionListener(new TableActionListener(){

            public void cellSelected(TableActionEvent event) {
                PageState state = event.getPageState();
                TableColumn col = DecisionTreeOptionTable.this.getColumnModel().get(event.getColumn().intValue());
                int colIndex = event.getColumn();
                if (colIndex == 3) {
                    if (DecisionTreeOptionTable.this.m_moveOption.getSelectedKey(state) == null) {
                        DecisionTreeOptionTable.this.m_moveOption.setSelectedKey(state, DecisionTreeOptionTable.this.m_selOption.getSelectedKey(state));
                    } else {
                        BigDecimal id = (BigDecimal)DecisionTreeOptionTable.this.m_moveOption.getSelectedKey(state);
                        DecisionTreeSectionOption option = new DecisionTreeSectionOption(id);
                        BigDecimal dest = new BigDecimal((String)event.getRowKey());
                        DecisionTreeSectionOption destOption = new DecisionTreeSectionOption(dest);
                        DecisionTreeSection section = option.getSection();
                        if (section.equals((Object)destOption.getSection())) {
                            int rank = destOption.getRank();
                            if (option.getRank() > rank) {
                                ++rank;
                            }
                            section.changeOptionRank(option, rank);
                            option.save();
                        }
                        DecisionTreeOptionTable.this.m_moveOption.setSelectedKey(state, null);
                    }
                }
            }

            public void headSelected(TableActionEvent event) {
            }
        });
    }

    public void setOptionModel(ItemSelectionModel selOption) {
        if (selOption == null) {
            s_log.warn((Object)"null item model");
        }
        this.m_selOption = selOption;
    }

    public class SectionTableCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private boolean m_active;

        public SectionTableCellRenderer() {
            this(false);
        }

        public SectionTableCellRenderer(boolean active) {
            this.m_active = active;
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            boolean active;
            Object ret = null;
            SecurityManager sm = CMS.getSecurityManager((PageState)state);
            ContentItem item = (ContentItem)DecisionTreeOptionTable.this.m_selTree.getSelectedObject(state);
            boolean bl = active = this.m_active && sm.canAccess(state.getRequest(), "edit_item", item);
            ret = value == null ? new Label("", false) : (value instanceof Label ? (active ? new ControlLink((Component)value) : (Component)value) : (Component)value);
            return ret;
        }
    }

    protected class OptionTableModel
    implements TableModel {
        private TableColumnModel m_colModel;
        private PageState m_state;
        private DecisionTreeSectionOptionCollection m_options;
        private ItemSelectionModel m_moveOption;
        private DecisionTreeSectionOption m_option;

        public OptionTableModel(Table table, PageState state, DecisionTree tree, ItemSelectionModel moveOption) {
            this.m_colModel = table.getColumnModel();
            this.m_state = state;
            this.m_options = tree.getOptions();
            this.m_moveOption = moveOption;
        }

        public int getColumnCount() {
            return this.m_colModel.size();
        }

        public boolean nextRow() {
            if (this.m_options.next()) {
                this.m_option = this.m_options.getOption();
                return true;
            }
            return false;
        }

        public Object getElementAt(int columnIndex) {
            if (this.m_colModel == null) {
                return null;
            }
            if (columnIndex == 0) {
                return this.m_option.getSection().getTitle();
            }
            if (columnIndex == 1) {
                return this.m_option.getLabel();
            }
            if (columnIndex == 2) {
                return new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.table.link_edit"));
            }
            if (columnIndex == 3) {
                if (this.m_moveOption.getSelectedKey(this.m_state) == null) {
                    return new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.table.link_move"));
                }
                DecisionTreeSectionOption src = new DecisionTreeSectionOption(new BigDecimal((String)this.m_moveOption.getSelectedKey(this.m_state)));
                if (this.m_option.getSection().equals((Object)src.getSection())) {
                    if (this.m_option.getLabel().equals(src.getLabel())) {
                        return new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.table.link_no_move"));
                    }
                    return new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.table.link_move_below"));
                }
                return null;
            }
            if (columnIndex == 4) {
                return new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.options.table.link_delete"));
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_option.getID();
        }
    }

    protected class OptionTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        protected ItemSelectionModel m_selTree;
        protected ItemSelectionModel m_moveOption;

        public OptionTableModelBuilder(ItemSelectionModel selTree, ItemSelectionModel moveOption) {
            this.m_selTree = selTree;
            this.m_moveOption = moveOption;
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            DecisionTree tree = (DecisionTree)this.m_selTree.getSelectedObject(state);
            return new OptionTableModel(table, state, tree, this.m_moveOption);
        }
    }
}

