/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.DecisionTree;
import com.arsdigita.cms.contenttypes.ui.DecisionTreePropertiesStep;
import com.arsdigita.cms.contenttypes.util.DecisionTreeGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.BasicPageForm;

public class DecisionTreePropertiesForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private static final String ID = "FORM_PROPERTIES";
    public static final String DESCRIPTION = "description";
    public static final String CANCEL_URL = "cancelURL";
    private DecisionTreePropertiesStep m_step;

    public DecisionTreePropertiesForm(ItemSelectionModel itemModel, DecisionTreePropertiesStep step) {
        super(ID, itemModel);
        this.m_step = step;
        this.addSubmissionListener(this);
    }

    protected void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.properties.form.description_label")));
        TextArea description = new TextArea((ParameterModel)new TrimmedStringParameter(DESCRIPTION));
        description.setRows(5);
        description.setCols(30);
        this.add((Component)description);
        this.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.properties.cancel_url")));
        TextField cancelURL = new TextField((ParameterModel)new StringParameter(CANCEL_URL));
        cancelURL.setSize(60);
        this.add((Component)cancelURL);
    }

    public void submitted(FormSectionEvent fse) {
        PageState state = fse.getPageState();
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(state)) {
            this.m_step.cancelStreamlinedCreation(state);
        }
    }

    public void process(FormSectionEvent fse) {
        PageState state = fse.getPageState();
        FormData data = fse.getFormData();
        DecisionTree decisionTree = (DecisionTree)this.processBasicWidgets(fse);
        decisionTree.setDescription((String)data.get((Object)DESCRIPTION));
        decisionTree.setCancelURL((String)data.get((Object)CANCEL_URL));
        decisionTree.save();
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(state);
        }
    }

    public void init(FormSectionEvent fse) {
        DecisionTree item = (DecisionTree)this.initBasicWidgets(fse);
        FormData data = fse.getFormData();
        data.put((Object)DESCRIPTION, (Object)item.getDescription());
        data.put((Object)CANCEL_URL, (Object)item.getCancelURL());
    }
}

