/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.DecisionTree;
import com.arsdigita.cms.contenttypes.DecisionTreeSection;
import com.arsdigita.cms.contenttypes.util.DecisionTreeGlobalizationUtil;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

public class DecisionTreeSectionDeleteForm
extends Form
implements FormInitListener,
FormSubmissionListener,
FormProcessListener {
    private static final Logger log = Logger.getLogger((String)DecisionTreeSectionDeleteForm.class.getName());
    protected ItemSelectionModel m_selTree;
    protected ItemSelectionModel m_selSection;
    protected SaveCancelSection m_saveCancelSection;
    private Label m_sectionNameLabel;
    private String[] m_sectionNameValue = new String[1];

    public DecisionTreeSectionDeleteForm(ItemSelectionModel selArticle, ItemSelectionModel selSection) {
        super("DecisionTreeSectionDeleteForm", (Container)new ColumnPanel(2));
        this.m_selTree = selArticle;
        this.m_selSection = selSection;
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
        panel.setWidth("100%");
        this.m_sectionNameLabel = new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.delete_section_msg", this.m_sectionNameValue));
        this.add((Component)this.m_sectionNameLabel, 65);
        this.addSaveCancelSection();
        this.addInitListener(this);
        this.addSubmissionListener(this);
        this.addProcessListener(this);
    }

    protected SaveCancelSection addSaveCancelSection() {
        this.m_saveCancelSection = new SaveCancelSection();
        this.m_saveCancelSection.getSaveButton().setButtonLabel(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.delete_button"));
        this.add((Component)this.m_saveCancelSection, 65);
        return this.m_saveCancelSection;
    }

    public void init(FormSectionEvent event) throws FormProcessException {
        String sectionTitle = " ";
        PageState state = event.getPageState();
        DecisionTreeSection section = (DecisionTreeSection)this.m_selSection.getSelectedObject(state);
        if (section == null) {
            log.error((Object)"No section selected");
        } else if (section.getTitle() != null) {
            sectionTitle = section.getTitle();
        }
        this.m_sectionNameValue[0] = sectionTitle;
    }

    public void submitted(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        if (this.m_saveCancelSection.getCancelButton().isSelected(state)) {
            throw new FormProcessException((String)DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.form.submission_cancelled").localize());
        }
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        DecisionTree article = (DecisionTree)this.m_selTree.getSelectedObject(state);
        DecisionTreeSection section = (DecisionTreeSection)this.m_selSection.getSelectedObject(state);
        Assert.exists((Object)((Object)article), DecisionTree.class);
        Assert.exists((Object)((Object)section), DecisionTreeSection.class);
        article.removeSection(section);
        log.debug((Object)("section " + this.m_selSection.getSelectedKey(state) + " delete"));
    }
}

