/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.contenttypes.DecisionTree;
import com.arsdigita.cms.contenttypes.DecisionTreeSection;
import com.arsdigita.cms.contenttypes.ui.DecisionTreeParameterNameValidationListener;
import com.arsdigita.cms.contenttypes.ui.DecisionTreeSectionStep;
import com.arsdigita.cms.contenttypes.util.DecisionTreeGlobalizationUtil;
import com.arsdigita.cms.ui.CMSDHTMLEditor;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class DecisionTreeSectionEditForm
extends Form
implements FormInitListener,
FormProcessListener,
FormSubmissionListener {
    private static final Logger log = Logger.getLogger(DecisionTreeSectionEditForm.class);
    private ItemSelectionModel m_selTree;
    private ItemSelectionModel m_selSection;
    private BigDecimalParameter m_instructionsParam;
    private ItemSelectionModel m_selInstructions;
    private DecisionTreeSectionStep m_container;
    private SaveCancelSection m_saveCancelSection;
    public static final String TITLE = "title";
    public static final String PARAMETER_NAME = "parameterName";
    public static final String INSTRUCTIONS = "instructions";
    private static final String INSTRUCTIONS_PARAM = "instructionsParam";

    public DecisionTreeSectionEditForm(ItemSelectionModel selTree, ItemSelectionModel selSection) {
        this(selTree, selSection, null);
    }

    public DecisionTreeSectionEditForm(ItemSelectionModel selTree, ItemSelectionModel selSection, DecisionTreeSectionStep container) {
        super("SectionEditForm", (Container)new ColumnPanel(2));
        this.m_selTree = selTree;
        this.m_selSection = selSection;
        this.m_container = container;
        this.m_instructionsParam = new BigDecimalParameter(INSTRUCTIONS_PARAM);
        this.m_selInstructions = new ItemSelectionModel(TextAsset.class.getName(), "com.arsdigita.cms.TextAsset", this.m_instructionsParam);
        this.setMethod("post");
        this.setEncType("multipart/form-data");
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
        panel.setWidth("100%");
        this.addWidgets();
        this.addSaveCancelSection();
        this.addInitListener(this);
        this.addSubmissionListener(this);
        this.addProcessListener(this);
    }

    protected SaveCancelSection addSaveCancelSection() {
        this.m_saveCancelSection = new SaveCancelSection();
        this.add((Component)this.m_saveCancelSection, 65);
        return this.m_saveCancelSection;
    }

    public SaveCancelSection getSaveCancelSection() {
        return this.m_saveCancelSection;
    }

    protected void addWidgets() {
        this.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.form.title_label")));
        TextField titleWidget = new TextField((ParameterModel)new TrimmedStringParameter(TITLE));
        titleWidget.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        this.add((Component)titleWidget);
        this.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.form.parameter_name_label")));
        TextField parameterWidget = new TextField((ParameterModel)new TrimmedStringParameter(PARAMETER_NAME));
        parameterWidget.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        parameterWidget.addValidationListener((ParameterListener)new DecisionTreeParameterNameValidationListener());
        this.add((Component)parameterWidget);
        this.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.form.instructions_label")), 65);
        CMSDHTMLEditor textWidget = new CMSDHTMLEditor((ParameterModel)new TrimmedStringParameter(INSTRUCTIONS));
        textWidget.setRows(40);
        textWidget.setCols(70);
        textWidget.setWrap(2);
        this.add((Component)textWidget, 65);
    }

    public void init(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        FormData data = event.getFormData();
        this.m_selInstructions.setSelectedObject(state, null);
        if (this.m_selSection.getSelectedKey(state) != null) {
            BigDecimal id = new BigDecimal(this.m_selSection.getSelectedKey(state).toString());
            try {
                DecisionTreeSection section = new DecisionTreeSection(id);
                data.put((Object)TITLE, (Object)section.getTitle());
                data.put((Object)PARAMETER_NAME, (Object)section.getParameterName());
                TextAsset t = section.getInstructions();
                if (t != null) {
                    this.m_selInstructions.setSelectedObject(state, (DomainObject)t);
                    data.put((Object)INSTRUCTIONS, (Object)t.getText());
                }
            }
            catch (DataObjectNotFoundException ex) {
                log.error((Object)("Section(" + id + ") could not be found"));
            }
        }
    }

    public void submitted(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        if (this.m_saveCancelSection.getCancelButton().isSelected(state) && this.m_container != null) {
            this.m_container.onlyShowComponent(state, "sec_tbl" + this.m_container.getTypeIDStr());
            throw new FormProcessException((String)DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.form.submission_cancelled").localize());
        }
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        String text;
        DecisionTree tree;
        PageState state = event.getPageState();
        FormData data = event.getFormData();
        BigDecimal id = new BigDecimal(this.m_selTree.getSelectedKey(state).toString());
        try {
            tree = new DecisionTree(id);
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
        DecisionTreeSection section = (DecisionTreeSection)this.m_selSection.getSelectedObject(state);
        if (section == null) {
            section = this.createSection(event, tree);
            tree.addSection(section);
        }
        section.setTitle((String)data.get((Object)TITLE));
        section.setParameterName((String)data.get((Object)PARAMETER_NAME));
        TextAsset textAsset = (TextAsset)this.m_selInstructions.getSelectedObject(state);
        if (textAsset == null) {
            textAsset = new TextAsset();
            textAsset.setName(section.getName() + " text");
            this.m_selInstructions.setSelectedObject(state, (DomainObject)textAsset);
            section.setInstructions(textAsset);
        }
        if ((text = (String)data.get((Object)INSTRUCTIONS)) == null) {
            text = "";
        }
        textAsset.setText(text);
        if (this.m_container != null) {
            this.m_container.onlyShowComponent(state, "sec_tbl" + this.m_container.getTypeIDStr());
        }
    }

    protected DecisionTreeSection createSection(FormSectionEvent event, DecisionTree tree) {
        FormData data = event.getFormData();
        DecisionTreeSection section = new DecisionTreeSection();
        section.setTitle((String)data.get((Object)TITLE));
        section.setName(tree.getName() + ": " + (String)data.get((Object)TITLE));
        return section;
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_instructionsParam);
    }
}

