/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.DecisionTree;
import com.arsdigita.cms.contenttypes.DecisionTreeSection;
import com.arsdigita.cms.contenttypes.ui.DecisionTreeSectionDeleteForm;
import com.arsdigita.cms.contenttypes.ui.DecisionTreeSectionEditForm;
import com.arsdigita.cms.contenttypes.ui.DecisionTreeSectionTable;
import com.arsdigita.cms.contenttypes.ui.ResettableContainer;
import com.arsdigita.cms.contenttypes.util.DecisionTreeGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.util.Assert;

public class DecisionTreeSectionStep
extends ResettableContainer {
    public static final String SECTION_TABLE = "sec_tbl";
    public static final String SECTION_EDIT = "sec_edt";
    public static final String SECTION_DEL = "sec_del";
    public static final String DATA_TABLE = "dataTable";
    public static final String ACTION_LINK = "actionLink";
    protected AuthoringKitWizard m_wizard;
    protected ItemSelectionModel m_selTree;
    protected ItemSelectionModel m_selSection;
    protected DecisionTreeSectionTable m_sectionTable;
    protected DecisionTreeSectionEditForm m_sectionEdit;
    protected DecisionTreeSectionDeleteForm m_sectionDelete;
    private String m_typeIDStr;

    public DecisionTreeSectionStep(ItemSelectionModel selTree, AuthoringKitWizard wizard) {
        this.m_selTree = selTree;
        this.m_wizard = wizard;
        this.m_typeIDStr = wizard.getContentType().getID().toString();
        Assert.exists((Object)this.m_selTree, ItemSelectionModel.class);
        this.add((Component)this.buildSectionTable(), true);
        this.add((Component)this.buildSectionEdit(), false);
        this.add((Component)this.buildSectionDelete(), false);
    }

    protected Container buildSectionTable() {
        ColumnPanel c = new ColumnPanel(1);
        c.setKey(SECTION_TABLE + this.m_typeIDStr);
        c.setBorderColor("#FFFFFF");
        c.setPadColor("#FFFFFF");
        this.m_sectionTable = new DecisionTreeSectionTable(this.m_selTree);
        this.m_sectionTable.setClassAttr(DATA_TABLE);
        this.m_selSection = new ItemSelectionModel(DecisionTreeSection.class.getName(), "com.arsdigita.cms.contenttypes.DecisionTreeSection", this.m_sectionTable.getRowSelectionModel());
        this.m_sectionTable.setSectionModel(this.m_selSection);
        Label emptyView = new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.no_sections_yet"));
        this.m_sectionTable.setEmptyView((Component)emptyView);
        this.m_sectionTable.addTableActionListener(new TableActionListener(){

            public void cellSelected(TableActionEvent event) {
                PageState state = event.getPageState();
                int col = event.getColumn();
                if (col == 2) {
                    DecisionTreeSectionStep.this.onlyShowComponent(state, DecisionTreeSectionStep.SECTION_DEL + DecisionTreeSectionStep.this.m_typeIDStr);
                } else if (col == 1) {
                    DecisionTreeSectionStep.this.onlyShowComponent(state, DecisionTreeSectionStep.SECTION_EDIT + DecisionTreeSectionStep.this.m_typeIDStr);
                } else if (col == 3) {
                    DecisionTree tree = (DecisionTree)DecisionTreeSectionStep.this.m_selTree.getSelectedObject(state);
                    DecisionTreeSection section = (DecisionTreeSection)DecisionTreeSectionStep.this.m_selSection.getSelectedItem(state);
                    tree.setFirstSection(section);
                    tree.save();
                }
            }

            public void headSelected(TableActionEvent e) {
            }
        });
        c.add((Component)this.m_sectionTable);
        c.add((Component)this.buildAddLink());
        return c;
    }

    protected Container buildSectionEdit() {
        ColumnPanel c = new ColumnPanel(1);
        c.setKey(SECTION_EDIT + this.m_typeIDStr);
        c.setBorderColor("#FFFFFF");
        c.setPadColor("#FFFFFF");
        c.add((Component)new Label(new PrintListener(){

            public void prepare(PrintEvent event) {
                PageState state = event.getPageState();
                Label label = (Label)event.getTarget();
                if (DecisionTreeSectionStep.this.m_selSection.getSelectedKey(state) == null) {
                    label.setLabel(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.add"));
                } else {
                    label.setLabel(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.edit"));
                }
            }
        }));
        this.m_sectionEdit = new DecisionTreeSectionEditForm(this.m_selTree, this.m_selSection, this);
        c.add((Component)this.m_sectionEdit);
        c.add((Component)this.buildViewAllLink());
        c.add((Component)this.buildAddLink());
        return c;
    }

    protected Container buildSectionDelete() {
        ColumnPanel c = new ColumnPanel(1);
        c.setKey(SECTION_DEL + this.m_typeIDStr);
        c.setBorderColor("#FFFFFF");
        c.setPadColor("#FFFFFF");
        c.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.delete")));
        this.m_sectionDelete = new DecisionTreeSectionDeleteForm(this.m_selTree, this.m_selSection);
        this.m_sectionDelete.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent e) {
                PageState state = e.getPageState();
                DecisionTreeSectionStep.this.onlyShowComponent(state, DecisionTreeSectionStep.SECTION_TABLE + DecisionTreeSectionStep.this.m_typeIDStr);
            }
        });
        c.add((Component)this.m_sectionDelete);
        c.add((Component)this.buildViewAllLink());
        return c;
    }

    protected ActionLink buildViewAllLink() {
        ActionLink viewAllLink = new ActionLink(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.view_all"));
        viewAllLink.setClassAttr(ACTION_LINK);
        viewAllLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DecisionTreeSectionStep.this.onlyShowComponent(event.getPageState(), DecisionTreeSectionStep.SECTION_TABLE + DecisionTreeSectionStep.this.m_typeIDStr);
            }
        });
        return viewAllLink;
    }

    protected ActionLink buildAddLink() {
        ActionLink addLink = new ActionLink(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.add_new_label")){

            public boolean isVisible(PageState state) {
                SecurityManager sm = CMS.getSecurityManager((PageState)state);
                ContentItem item = (ContentItem)DecisionTreeSectionStep.this.m_selTree.getSelectedObject(state);
                return super.isVisible(state) && sm.canAccess(state.getRequest(), "edit_item", item);
            }
        };
        addLink.setClassAttr(ACTION_LINK);
        addLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                DecisionTreeSectionStep.this.m_selSection.clearSelection(state);
                DecisionTreeSectionStep.this.onlyShowComponent(state, DecisionTreeSectionStep.SECTION_EDIT + DecisionTreeSectionStep.this.m_typeIDStr);
            }
        });
        return addLink;
    }

    public String getTypeIDStr() {
        return this.m_typeIDStr;
    }
}

