/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.DecisionTree;
import com.arsdigita.cms.contenttypes.DecisionTreeSection;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionCollection;
import com.arsdigita.cms.contenttypes.util.DecisionTreeGlobalizationUtil;
import com.arsdigita.util.LockableImpl;
import org.apache.log4j.Logger;

public class DecisionTreeSectionTable
extends Table {
    public static final int COL_IDX_TITLE = 0;
    public static final int COL_IDX_EDIT = 1;
    public static final int COL_IDX_DEL = 2;
    public static final int COL_IDX_FIRST = 3;
    private ItemSelectionModel m_selTree;
    private static final Logger s_log = Logger.getLogger(DecisionTreeSectionTable.class);

    public DecisionTreeSectionTable(ItemSelectionModel selArticle) {
        this.m_selTree = selArticle;
        TableColumnModel model = this.getColumnModel();
        model.add(new TableColumn(0, (Object)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.table.header_section"))));
        model.add(new TableColumn(1, (Object)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.table.header_edit"))));
        model.add(new TableColumn(2, (Object)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.table.header_delete"))));
        model.add(new TableColumn(3, (Object)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.table.header_first_section"))));
        model.get(1).setCellRenderer((TableCellRenderer)new SectionTableCellRenderer(true));
        model.get(2).setCellRenderer((TableCellRenderer)new SectionTableCellRenderer(true));
        model.get(3).setCellRenderer((TableCellRenderer)new SectionTableCellRenderer(true));
        this.setModelBuilder(new SectionTableModelBuilder(this.m_selTree));
    }

    public void setSectionModel(ItemSelectionModel selSection) {
        if (selSection == null) {
            s_log.warn((Object)"null item model");
        }
    }

    public class SectionTableCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private boolean m_active;

        public SectionTableCellRenderer() {
            this(false);
        }

        public SectionTableCellRenderer(boolean active) {
            this.m_active = active;
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            boolean active;
            Object ret = null;
            SecurityManager sm = CMS.getSecurityManager((PageState)state);
            ContentItem item = (ContentItem)DecisionTreeSectionTable.this.m_selTree.getSelectedObject(state);
            boolean bl = active = this.m_active && sm.canAccess(state.getRequest(), "edit_item", item);
            ret = value == null ? new Label("", false) : (value instanceof Label ? (active ? new ControlLink((Component)value) : (Component)value) : (Component)value);
            return ret;
        }
    }

    protected class SectionTableModel
    implements TableModel {
        private TableColumnModel m_colModel;
        private DecisionTreeSectionCollection m_sections;
        private DecisionTreeSection m_section;

        public SectionTableModel(Table table, PageState state, DecisionTree tree) {
            this.m_colModel = table.getColumnModel();
            this.m_sections = tree.getSections();
        }

        public int getColumnCount() {
            return this.m_colModel.size();
        }

        public boolean nextRow() {
            if (this.m_sections.next()) {
                this.m_section = this.m_sections.getSection();
                return true;
            }
            return false;
        }

        public Object getElementAt(int columnIndex) {
            if (this.m_colModel == null) {
                return null;
            }
            if (columnIndex == 0) {
                return this.m_section.getTitle();
            }
            if (columnIndex == 1) {
                return new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.table.link_edit"));
            }
            if (columnIndex == 2) {
                return new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.table.link_delete"));
            }
            if (columnIndex == 3) {
                DecisionTree tree = this.m_section.getTree();
                DecisionTreeSection firstSection = tree.getFirstSection();
                if (firstSection != null && firstSection.getID() == this.m_section.getID()) {
                    return null;
                }
                return new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.sections.table.link_set_first"));
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_section.getID();
        }
    }

    protected class SectionTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        protected ItemSelectionModel m_selTree;

        public SectionTableModelBuilder(ItemSelectionModel selTree) {
            this.m_selTree = selTree;
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            DecisionTree tree = (DecisionTree)this.m_selTree.getSelectedObject(state);
            return new SectionTableModel(table, state, tree);
        }
    }
}

