/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.DecisionTreeOptionTarget;
import com.arsdigita.cms.contenttypes.util.DecisionTreeGlobalizationUtil;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class DecisionTreeTargetDeleteForm
extends Form
implements FormInitListener,
FormSubmissionListener,
FormProcessListener {
    private static final Logger s_log = Logger.getLogger((String)DecisionTreeTargetDeleteForm.class.getName());
    protected ItemSelectionModel m_selTree;
    protected ItemSelectionModel m_selTarget;
    protected SaveCancelSection m_saveCancelSection;
    private Label m_targetMatchValue;

    public DecisionTreeTargetDeleteForm(ItemSelectionModel selTree, ItemSelectionModel selTarget) {
        super("DecisionTreeTargetDeleteForm", (Container)new ColumnPanel(2));
        this.m_selTree = selTree;
        this.m_selTarget = selTarget;
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
        panel.setWidth("100%");
        this.m_targetMatchValue = new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.form.delete.target_match_value"));
        this.add((Component)this.m_targetMatchValue, 65);
        this.addSaveCancelSection();
        this.addInitListener(this);
        this.addSubmissionListener(this);
        this.addProcessListener(this);
    }

    protected SaveCancelSection addSaveCancelSection() {
        this.m_saveCancelSection = new SaveCancelSection();
        this.m_saveCancelSection.getSaveButton().setButtonLabel(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.form.delete.delete_button"));
        this.add((Component)this.m_saveCancelSection, 65);
        return this.m_saveCancelSection;
    }

    public void init(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        BigDecimal id = new BigDecimal(this.m_selTarget.getSelectedKey(state).toString());
        DecisionTreeOptionTarget target = new DecisionTreeOptionTarget(id);
        this.m_targetMatchValue.setLabel(target.getMatchOption().getLabel(), state);
    }

    public void submitted(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        if (this.m_saveCancelSection.getCancelButton().isSelected(state)) {
            throw new FormProcessException((String)DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.submission_cancelled").localize());
        }
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        BigDecimal id = new BigDecimal(this.m_selTarget.getSelectedKey(state).toString());
        DecisionTreeOptionTarget target = new DecisionTreeOptionTarget(id);
        target.delete();
    }
}

