/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.DecisionTree;
import com.arsdigita.cms.contenttypes.DecisionTreeOptionTarget;
import com.arsdigita.cms.contenttypes.DecisionTreeSection;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionCollection;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionOption;
import com.arsdigita.cms.contenttypes.DecisionTreeSectionOptionCollection;
import com.arsdigita.cms.contenttypes.ui.DecisionTreeTargetStep;
import com.arsdigita.cms.contenttypes.util.DecisionTreeGlobalizationUtil;
import java.math.BigDecimal;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class DecisionTreeTargetEditForm
extends Form
implements FormInitListener,
FormProcessListener,
FormSubmissionListener {
    private static final Logger s_log = Logger.getLogger(DecisionTreeTargetEditForm.class);
    private ItemSelectionModel m_selTree;
    private ItemSelectionModel m_selTarget;
    private DecisionTreeTargetStep m_container;
    private SaveCancelSection m_saveCancelSection;
    private SingleSelect m_matchValueWidget;
    private SingleSelect m_targetSectionWidget;
    private TextField m_targetURLWidget;
    public static final String MATCH_OPTION = "matchOption";
    public static final String TARGET_URL = "targetURL";
    public static final String TARGET_SECTION = "targetSection";

    public DecisionTreeTargetEditForm(ItemSelectionModel selTree, ItemSelectionModel selTarget) {
        this(selTree, selTarget, null);
    }

    public DecisionTreeTargetEditForm(ItemSelectionModel selTree, ItemSelectionModel selTarget, DecisionTreeTargetStep container) {
        super("DecisionTreeTargetEditForm", (Container)new ColumnPanel(2));
        this.m_selTree = selTree;
        this.m_selTarget = selTarget;
        this.m_container = container;
        this.setMethod("post");
        this.setEncType("multipart/form-data");
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
        panel.setWidth("100%");
        this.addWidgets();
        this.addSaveCancelSection();
        this.addInitListener(this);
        this.addSubmissionListener(this);
        this.addProcessListener(this);
    }

    protected SaveCancelSection addSaveCancelSection() {
        this.m_saveCancelSection = new SaveCancelSection();
        this.add((Component)this.m_saveCancelSection, 65);
        return this.m_saveCancelSection;
    }

    public SaveCancelSection getSaveCancelSection() {
        return this.m_saveCancelSection;
    }

    private void initSectionOptions(PrintEvent e) {
        DecisionTreeSectionCollection sections;
        PageState state = e.getPageState();
        SingleSelect target = (SingleSelect)e.getTarget();
        DecisionTree tree = (DecisionTree)this.m_selTree.getSelectedObject(state);
        if (tree != null && (sections = tree.getSections()) != null) {
            while (sections.next()) {
                DecisionTreeSection section = sections.getSection();
                Option option = new Option(section.getID().toString(), section.getTitle());
                target.addOption(option, state);
            }
            sections.close();
        }
    }

    private void initTargetOptions(PrintEvent e) {
        DecisionTreeSectionCollection sections;
        PageState state = e.getPageState();
        SingleSelect target = (SingleSelect)e.getTarget();
        DecisionTree tree = (DecisionTree)this.m_selTree.getSelectedObject(state);
        if (tree != null && (sections = tree.getSections()) != null) {
            while (sections.next()) {
                DecisionTreeSection section = sections.getSection();
                Option option = new Option(section.getID().toString(), section.getTitle());
                target.addOption(option, state);
            }
            sections.close();
        }
    }

    private void initMatchOptions(PrintEvent e) {
        DecisionTreeSectionOptionCollection sectionOptions;
        PageState state = e.getPageState();
        SingleSelect target = (SingleSelect)e.getTarget();
        DecisionTree tree = (DecisionTree)this.m_selTree.getSelectedObject(state);
        if (tree != null && (sectionOptions = tree.getOptions()) != null) {
            while (sectionOptions.next()) {
                DecisionTreeSectionOption sectionOption = sectionOptions.getOption();
                String label = sectionOption.getSection().getTitle() + " : " + sectionOption.getLabel();
                Option option = new Option(sectionOption.getID().toString(), label);
                target.addOption(option, state);
            }
            sectionOptions.close();
        }
    }

    public void init(FormSectionEvent fse) {
        PageState state = fse.getPageState();
        FormData data = fse.getFormData();
        if (this.m_selTarget.getSelectedKey(state) != null) {
            BigDecimal id = new BigDecimal(this.m_selTarget.getSelectedKey(state).toString());
            DecisionTreeOptionTarget target = new DecisionTreeOptionTarget(id);
            data.put((Object)MATCH_OPTION, (Object)target.getMatchOption().getID());
            data.put((Object)TARGET_URL, (Object)target.getTargetURL());
            DecisionTreeSection targetSection = target.getTargetSection();
            if (targetSection != null) {
                data.put((Object)TARGET_SECTION, (Object)targetSection.getID());
            }
        }
    }

    protected void addWidgets() {
        Option pleaseSelect = new Option("", (Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.form.please_select")));
        Option none = new Option("", (Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.form.none")));
        this.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.form.match_value")));
        this.m_matchValueWidget = new SingleSelect(MATCH_OPTION);
        this.m_matchValueWidget.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_matchValueWidget.addOption(pleaseSelect);
        try {
            this.m_matchValueWidget.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    DecisionTreeTargetEditForm.this.initMatchOptions(e);
                }
            });
        }
        catch (TooManyListenersException e) {
            throw new RuntimeException(e);
        }
        this.add((Component)this.m_matchValueWidget);
        this.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.form.target_url_label")));
        this.m_targetURLWidget = new TextField(TARGET_URL);
        this.m_targetURLWidget.setSize(60);
        this.add((Component)this.m_targetURLWidget);
        this.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.form.target_section_label")));
        this.m_targetSectionWidget = new SingleSelect(TARGET_SECTION);
        this.m_targetSectionWidget.addOption(none);
        try {
            this.m_targetSectionWidget.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    DecisionTreeTargetEditForm.this.initTargetOptions(e);
                }
            });
        }
        catch (TooManyListenersException e) {
            throw new RuntimeException(e);
        }
        this.add((Component)this.m_targetSectionWidget);
        this.addValidationListener(new FormValidationListener(){

            public final void validate(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                if ("".equals(DecisionTreeTargetEditForm.this.m_targetURLWidget.getValue(state)) && "".equals(DecisionTreeTargetEditForm.this.m_targetSectionWidget.getValue(state))) {
                    String msg = (String)DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.form.target_required").localize();
                    throw new FormProcessException(msg);
                }
                if (!"".equals(DecisionTreeTargetEditForm.this.m_targetURLWidget.getValue(state)) && !"".equals(DecisionTreeTargetEditForm.this.m_targetSectionWidget.getValue(state))) {
                    String msg = (String)DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.form.duplicate_target").localize();
                    throw new FormProcessException(msg);
                }
            }
        });
    }

    public void submitted(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        if (this.m_saveCancelSection.getCancelButton().isSelected(state) && this.m_container != null) {
            this.m_container.onlyShowComponent(state, "tgt_tbl" + this.m_container.getTypeIDStr());
            throw new FormProcessException((String)DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.form.submission_cancelled").localize());
        }
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        FormData data = event.getFormData();
        DecisionTreeSectionOption matchOption = new DecisionTreeSectionOption(new BigDecimal((String)data.get((Object)MATCH_OPTION)));
        DecisionTreeSection targetSection = null;
        String sectionID = (String)data.get((Object)TARGET_SECTION);
        if (!"".equals(sectionID)) {
            targetSection = new DecisionTreeSection(new BigDecimal(sectionID));
        }
        DecisionTreeOptionTarget target = null;
        if (this.m_selTarget.getSelectedKey(state) != null) {
            BigDecimal id = new BigDecimal(this.m_selTarget.getSelectedKey(state).toString());
            target = new DecisionTreeOptionTarget(id);
        } else {
            target = new DecisionTreeOptionTarget();
            target.setName("OptionTarget " + target.getID());
        }
        target.setMatchOption(matchOption);
        target.setTargetURL((String)data.get((Object)TARGET_URL));
        target.setTargetSection(targetSection);
        if (this.m_container != null) {
            this.m_container.onlyShowComponent(state, "tgt_tbl" + this.m_container.getTypeIDStr());
        }
    }

    public void register(Page p) {
        super.register(p);
    }
}

