/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.DecisionTreeSection;
import com.arsdigita.cms.contenttypes.ui.DecisionTreeTargetDeleteForm;
import com.arsdigita.cms.contenttypes.ui.DecisionTreeTargetEditForm;
import com.arsdigita.cms.contenttypes.ui.DecisionTreeTargetTable;
import com.arsdigita.cms.contenttypes.ui.ResettableContainer;
import com.arsdigita.cms.contenttypes.util.DecisionTreeGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.util.Assert;

public class DecisionTreeTargetStep
extends ResettableContainer {
    public static final String TARGET_TABLE = "tgt_tbl";
    public static final String TARGET_EDIT = "tgt_edt";
    public static final String TARGET_DEL = "tgt_del";
    public static final String DATA_TABLE = "dataTable";
    public static final String ACTION_LINK = "actionLink";
    protected AuthoringKitWizard m_wizard;
    protected ItemSelectionModel m_selTree;
    protected ItemSelectionModel m_selTarget;
    protected DecisionTreeTargetTable m_targetTable;
    protected DecisionTreeTargetEditForm m_targetEdit;
    protected DecisionTreeTargetDeleteForm m_targetDelete;
    private String m_typeIDStr;

    public DecisionTreeTargetStep(ItemSelectionModel selTree, AuthoringKitWizard wizard) {
        this.m_selTree = selTree;
        this.m_wizard = wizard;
        this.m_typeIDStr = wizard.getContentType().getID().toString();
        Assert.exists((Object)this.m_selTree, ItemSelectionModel.class);
        this.add((Component)this.buildTargetTable(), true);
        this.add((Component)this.buildTargetEdit(), false);
        this.add((Component)this.buildTargetDelete(), false);
    }

    protected Container buildTargetTable() {
        ColumnPanel c = new ColumnPanel(1);
        c.setKey(TARGET_TABLE + this.m_typeIDStr);
        c.setBorderColor("#FFFFFF");
        c.setPadColor("#FFFFFF");
        this.m_targetTable = new DecisionTreeTargetTable(this.m_selTree);
        this.m_targetTable.setClassAttr(DATA_TABLE);
        this.m_selTarget = new ItemSelectionModel(DecisionTreeSection.class.getName(), "com.arsdigita.cms.contenttypes.DecisionTreeSection", this.m_targetTable.getRowSelectionModel());
        this.m_targetTable.setSectionModel(this.m_selTarget);
        Label emptyView = new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.none_yet"));
        this.m_targetTable.setEmptyView((Component)emptyView);
        this.m_targetTable.addTableActionListener(new TableActionListener(){

            public void cellSelected(TableActionEvent event) {
                PageState state = event.getPageState();
                int col = event.getColumn();
                if (col == 3) {
                    DecisionTreeTargetStep.this.onlyShowComponent(state, DecisionTreeTargetStep.TARGET_DEL + DecisionTreeTargetStep.this.m_typeIDStr);
                } else if (col == 2) {
                    DecisionTreeTargetStep.this.onlyShowComponent(state, DecisionTreeTargetStep.TARGET_EDIT + DecisionTreeTargetStep.this.m_typeIDStr);
                }
            }

            public void headSelected(TableActionEvent e) {
            }
        });
        c.add((Component)this.m_targetTable);
        c.add((Component)this.buildAddLink());
        return c;
    }

    protected Container buildTargetEdit() {
        ColumnPanel c = new ColumnPanel(1);
        c.setKey(TARGET_EDIT + this.m_typeIDStr);
        c.setBorderColor("#FFFFFF");
        c.setPadColor("#FFFFFF");
        c.add((Component)new Label(new PrintListener(){

            public void prepare(PrintEvent event) {
                PageState state = event.getPageState();
                Label label = (Label)event.getTarget();
                if (DecisionTreeTargetStep.this.m_selTarget.getSelectedKey(state) == null) {
                    label.setLabel(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.add"));
                } else {
                    label.setLabel(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.edit"));
                }
            }
        }));
        this.m_targetEdit = new DecisionTreeTargetEditForm(this.m_selTree, this.m_selTarget, this);
        c.add((Component)this.m_targetEdit);
        c.add((Component)this.buildViewAllLink());
        c.add((Component)this.buildAddLink());
        return c;
    }

    protected Container buildTargetDelete() {
        ColumnPanel c = new ColumnPanel(1);
        c.setKey(TARGET_DEL + this.m_typeIDStr);
        c.setBorderColor("#FFFFFF");
        c.setPadColor("#FFFFFF");
        c.add((Component)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.delete")));
        this.m_targetDelete = new DecisionTreeTargetDeleteForm(this.m_selTree, this.m_selTarget);
        this.m_targetDelete.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent e) {
                PageState state = e.getPageState();
                DecisionTreeTargetStep.this.onlyShowComponent(state, DecisionTreeTargetStep.TARGET_TABLE + DecisionTreeTargetStep.this.m_typeIDStr);
            }
        });
        c.add((Component)this.m_targetDelete);
        c.add((Component)this.buildViewAllLink());
        return c;
    }

    protected ActionLink buildViewAllLink() {
        ActionLink viewAllLink = new ActionLink(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.view_all"));
        viewAllLink.setClassAttr(ACTION_LINK);
        viewAllLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DecisionTreeTargetStep.this.onlyShowComponent(event.getPageState(), DecisionTreeTargetStep.TARGET_TABLE + DecisionTreeTargetStep.this.m_typeIDStr);
            }
        });
        return viewAllLink;
    }

    protected ActionLink buildAddLink() {
        ActionLink addLink = new ActionLink(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.add_new")){

            public boolean isVisible(PageState state) {
                SecurityManager sm = CMS.getSecurityManager((PageState)state);
                ContentItem item = (ContentItem)DecisionTreeTargetStep.this.m_selTree.getSelectedObject(state);
                return super.isVisible(state) && sm.canAccess(state.getRequest(), "edit_item", item);
            }
        };
        addLink.setClassAttr(ACTION_LINK);
        addLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                DecisionTreeTargetStep.this.m_selTarget.clearSelection(state);
                DecisionTreeTargetStep.this.onlyShowComponent(state, DecisionTreeTargetStep.TARGET_EDIT + DecisionTreeTargetStep.this.m_typeIDStr);
            }
        });
        return addLink;
    }

    public String getTypeIDStr() {
        return this.m_typeIDStr;
    }
}

