/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contenttypes.DecisionTree;
import com.arsdigita.cms.contenttypes.DecisionTreeOptionTarget;
import com.arsdigita.cms.contenttypes.DecisionTreeOptionTargetCollection;
import com.arsdigita.cms.contenttypes.util.DecisionTreeGlobalizationUtil;
import com.arsdigita.util.LockableImpl;
import org.apache.log4j.Logger;

public class DecisionTreeTargetTable
extends Table {
    private static final Logger s_log = Logger.getLogger(DecisionTreeTargetTable.class);
    public static final int COL_IDX_SECTION = 0;
    public static final int COL_IDX_MATCH = 1;
    public static final int COL_IDX_EDIT = 2;
    public static final int COL_IDX_DEL = 3;
    private ItemSelectionModel m_selTree;

    public DecisionTreeTargetTable(ItemSelectionModel selArticle) {
        this.m_selTree = selArticle;
        TableColumnModel model = this.getColumnModel();
        model.add(new TableColumn(0, (Object)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.table.header_section"))));
        model.add(new TableColumn(1, (Object)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.table.header_match"))));
        model.add(new TableColumn(2, (Object)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.table.header_edit"))));
        model.add(new TableColumn(3, (Object)new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.table.header_delete"))));
        model.get(2).setCellRenderer((TableCellRenderer)new SectionTableCellRenderer(true));
        model.get(3).setCellRenderer((TableCellRenderer)new SectionTableCellRenderer(true));
        this.setModelBuilder(new OptionTableModelBuilder(this.m_selTree));
    }

    public void setSectionModel(ItemSelectionModel selSection) {
        if (selSection == null) {
            s_log.warn((Object)"null item model");
        }
    }

    public class SectionTableCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private boolean m_active;

        public SectionTableCellRenderer() {
            this(false);
        }

        public SectionTableCellRenderer(boolean active) {
            this.m_active = active;
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            boolean active;
            Object ret = null;
            SecurityManager sm = CMS.getSecurityManager((PageState)state);
            ContentItem item = (ContentItem)DecisionTreeTargetTable.this.m_selTree.getSelectedObject(state);
            boolean bl = active = this.m_active && sm.canAccess(state.getRequest(), "edit_item", item);
            ret = value == null ? (Component)value : (value instanceof Label ? (active ? new ControlLink((Component)value) : (Component)value) : (Component)value);
            return ret;
        }
    }

    protected class TargetTableModel
    implements TableModel {
        private TableColumnModel m_colModel;
        private DecisionTreeOptionTargetCollection m_targets;
        private DecisionTreeOptionTarget m_target;

        public TargetTableModel(Table table, PageState state, DecisionTree tree) {
            this.m_colModel = table.getColumnModel();
            this.m_targets = tree.getTargets();
        }

        public int getColumnCount() {
            return this.m_colModel.size();
        }

        public boolean nextRow() {
            if (this.m_targets.next()) {
                this.m_target = this.m_targets.getTarget();
                return true;
            }
            return false;
        }

        public Object getElementAt(int columnIndex) {
            if (this.m_colModel == null) {
                return null;
            }
            if (columnIndex == 0) {
                return this.m_target.getMatchOption().getSection().getTitle();
            }
            if (columnIndex == 1) {
                return this.m_target.getMatchOption().getLabel();
            }
            if (columnIndex == 2) {
                return new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.table.link_edit"));
            }
            if (columnIndex == 3) {
                return new Label(DecisionTreeGlobalizationUtil.globalize("cms.contenttypes.ui.decisiontree.targets.table.link_delete"));
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_target.getID();
        }
    }

    protected class OptionTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        protected ItemSelectionModel m_selTree;

        public OptionTableModelBuilder(ItemSelectionModel selTree) {
            this.m_selTree = selTree;
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            DecisionTree tree = (DecisionTree)this.m_selTree.getSelectedObject(state);
            return new TargetTableModel(table, state, tree);
        }
    }
}

