/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Job;
import com.arsdigita.cms.contenttypes.ui.JobPropertyForm;
import com.arsdigita.cms.contenttypes.util.JobGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import java.text.DateFormat;

public class JobPropertiesStep
extends SimpleEditStep {
    public static String EDIT_SHEET_NAME = "edit";

    public JobPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        this.setDefaultEditKey(EDIT_SHEET_NAME);
        JobPropertyForm editSheet = new JobPropertyForm(itemModel, this);
        this.add(EDIT_SHEET_NAME, GlobalizationUtil.globalize((String)"cms.ui.edit"), (ComponentAccess)new WorkflowLockedComponentAccess((Component)editSheet, itemModel), editSheet.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(JobPropertiesStep.getJobPropertySheet(itemModel));
    }

    public static Component getJobPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.title"), "title");
        sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.name"), "name");
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.launch_date"), "launchDate", (DomainObjectPropertySheet.AttributeFormatter)new SimpleEditStep.LaunchDateAttributeFormatter());
        }
        sheet.add(JobGlobalizationUtil.globalize("cms.contenttypes.ui.job.overview"), "body");
        sheet.add(JobGlobalizationUtil.globalize("cms.contenttypes.ui.job.grade"), "grade");
        sheet.add(JobGlobalizationUtil.globalize("cms.contenttypes.ui.job.closing_date"), "closingDate", (DomainObjectPropertySheet.AttributeFormatter)new JobDateAttributeFormatter());
        sheet.add(JobGlobalizationUtil.globalize("cms.contenttypes.ui.job.salary"), "salary");
        sheet.add(JobGlobalizationUtil.globalize("cms.contenttypes.ui.job.ref_number"), "refNumber");
        sheet.add(JobGlobalizationUtil.globalize("cms.contenttypes.ui.job.department"), "department");
        sheet.add(JobGlobalizationUtil.globalize("cms.contenttypes.ui.job.job_description"), "jobDescription");
        sheet.add(JobGlobalizationUtil.globalize("cms.contenttypes.ui.job.person_specification"), "personSpecification");
        sheet.add(JobGlobalizationUtil.globalize("cms.contenttypes.ui.job.contact_details"), "contactDetails");
        return sheet;
    }

    private static class JobDateAttributeFormatter
    implements DomainObjectPropertySheet.AttributeFormatter {
        public String format(DomainObject obj, String attribute, PageState state) {
            if (obj != null && obj instanceof Job) {
                Job job = (Job)obj;
                Object field = job.get(attribute);
                if (field != null) {
                    return DateFormat.getDateInstance(1, GlobalizationHelper.getNegotiatedLocale()).format(field);
                }
                return (String)GlobalizationUtil.globalize((String)"cms.ui.unknown").localize();
            }
            return (String)GlobalizationUtil.globalize((String)"cms.ui.unknown").localize();
        }
    }
}

