/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.cms.freeform.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.DefaultTableColumnModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.Asset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.london.cms.freeform.FreeformContentItem;
import com.arsdigita.london.cms.freeform.ui.AssetSelectionModel;
import com.arsdigita.london.cms.freeform.ui.AssetTableCellRenderer;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.util.LockableImpl;

public class FreeformAssetView
extends BoxPanel {
    private static final String COLUMN_NAME = "Name";
    private static final String COLUMN_VALUE = "Value";
    private AssetSelectionModel m_assetModel;
    private Link m_download = new Link("Download Placeholder", "/foo/bar/baz");

    public FreeformAssetView() {
        super(2);
        this.m_assetModel = new AssetSelectionModel();
        Table t = new Table((TableModelBuilder)new AssetPropertyTableBuilder(this.m_assetModel), (TableColumnModel)new DefaultTableColumnModel());
        this.add((Component)t);
        t.setHeader(null);
        t.setDefaultCellRenderer((TableCellRenderer)new AssetTableCellRenderer(false));
        Label emptyView = new Label("No asset could be found");
        emptyView.setFontWeight("i");
        t.setEmptyView((Component)emptyView);
        TableColumnModel model = t.getColumnModel();
        model.add(new TableColumn(0, (Object)COLUMN_NAME));
        model.add(new TableColumn(1, (Object)COLUMN_VALUE));
        this.add((Component)this.m_download);
    }

    public FreeformAssetView(SingleSelectionModel assetModel, ItemSelectionModel itemModel) {
        this();
        this.m_assetModel.setAssetModel(assetModel);
        this.m_assetModel.setItemModel(itemModel);
    }

    public AssetSelectionModel getAssetSelectionModel() {
        return this.m_assetModel;
    }

    public void register(Page p) {
        super.register(p);
        this.m_assetModel.register(p, (Component)this);
    }

    public Asset getAsset(PageState state) {
        return this.m_assetModel.getAsset(state);
    }

    public FreeformContentItem getFreeformContentItem(PageState state) {
        return this.m_assetModel.getFreeformContentItem(state);
    }

    private static class AssetPropertyTableModel
    implements TableModel {
        private TableColumnModel m_columnModel;
        private PageState m_state;
        private AssetSelectionModel m_assetModel;
        private Asset m_asset;
        private int m_rowNum;

        public AssetPropertyTableModel(Table table, PageState state, AssetSelectionModel assetModel) {
            this.m_columnModel = table.getColumnModel();
            this.m_state = state;
            this.m_assetModel = assetModel;
            this.m_asset = assetModel.getAsset(state);
            this.m_rowNum = 0;
        }

        public int getColumnCount() {
            return this.m_columnModel.size();
        }

        public boolean nextRow() {
            if (this.m_asset != null && this.m_rowNum < 4) {
                ++this.m_rowNum;
                return true;
            }
            return false;
        }

        public Object getElementAt(int columnIndex) {
            if (this.m_columnModel == null) {
                return null;
            }
            TableColumn tc = this.m_columnModel.get(columnIndex);
            String columnName = (String)tc.getHeaderValue();
            if (FreeformAssetView.COLUMN_NAME.equals(columnName)) {
                String key = this.decodeKey(columnIndex);
                if (key != null) {
                    Label l = new Label(key);
                    l.setFontWeight("b");
                    return l;
                }
                return null;
            }
            if (FreeformAssetView.COLUMN_VALUE.equals(columnName)) {
                return this.decodeValue(columnIndex);
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.decodeKey(columnIndex);
        }

        private String decodeKey(int idx) {
            if (this.m_rowNum == 1) {
                return "Name:";
            }
            if (this.m_rowNum == 2) {
                return "Description:";
            }
            if (this.m_rowNum == 3) {
                return "MimeType:";
            }
            if (this.m_rowNum == 4) {
                return "Rank:";
            }
            return null;
        }

        private String decodeValue(int idx) {
            if (this.m_rowNum == 1) {
                return this.m_asset.getName();
            }
            if (this.m_rowNum == 2) {
                return this.m_asset.getDescription();
            }
            if (this.m_rowNum == 3) {
                MimeType type = this.m_asset.getMimeType();
                if (type != null) {
                    return type.getMimeType();
                }
                return "unknown";
            }
            if (this.m_rowNum == 4) {
                return this.m_assetModel.getRank(this.m_state);
            }
            return null;
        }
    }

    private static class AssetPropertyTableBuilder
    extends LockableImpl
    implements TableModelBuilder {
        AssetSelectionModel m_assetModel;

        public AssetPropertyTableBuilder(AssetSelectionModel assetModel) {
            this.m_assetModel = assetModel;
        }

        public TableModel makeModel(Table table, PageState state) {
            return new AssetPropertyTableModel(table, state, this.m_assetModel);
        }
    }
}

