/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.cms.freeform.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.london.cms.freeform.asset.FreeformBinaryAsset;
import com.arsdigita.london.cms.freeform.ui.FileUploadForm;
import com.arsdigita.london.cms.freeform.ui.ViewAssets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FreeformBinaryAssetEdit
extends FileUploadForm {
    private static final String NAME = "name";
    private static final String DESC = "desc";
    private ItemSelectionModel m_itemModel;
    private ItemSelectionModel m_assetModel;
    private ViewAssets m_view;
    private SaveCancelSection m_saveCancel;
    private TextField m_name;
    private TextField m_desc;

    public FreeformBinaryAssetEdit(SingleSelectionModel assetModel, ItemSelectionModel itemModel, ViewAssets view) {
        super((Container)new ColumnPanel(2));
        this.m_itemModel = itemModel;
        this.m_assetModel = new ItemSelectionModel(assetModel);
        this.m_view = view;
        this.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent event) {
                PageState state = event.getPageState();
                FreeformBinaryAsset asset = (FreeformBinaryAsset)FreeformBinaryAssetEdit.this.m_assetModel.getSelectedObject(state);
                if (asset != null) {
                    FreeformBinaryAssetEdit.this.m_name.setValue(state, (Object)asset.getName());
                    FreeformBinaryAssetEdit.this.m_desc.setValue(state, (Object)asset.getDescription());
                }
            }
        });
    }

    public Submit getCancelButton() {
        return this.m_saveCancel.getCancelButton();
    }

    @Override
    protected void addWidgets() {
        this.m_name = new TextField((ParameterModel)new StringParameter(NAME));
        this.add((Component)new Label("Name: "));
        this.add((Component)this.m_name);
        this.m_desc = new TextField((ParameterModel)new StringParameter(DESC));
        this.add((Component)new Label("Description: "));
        this.add((Component)this.m_desc);
        super.addWidgets();
    }

    @Override
    protected void addSubmitButton() {
        this.m_saveCancel = new SaveCancelSection();
        this.add((Component)this.m_saveCancel, 66);
    }

    protected FreeformBinaryAsset getBinaryAsset(FormSectionEvent event) {
        File file;
        PageState state = event.getPageState();
        FreeformBinaryAsset asset = (FreeformBinaryAsset)this.m_assetModel.getSelectedObject(state);
        if (asset == null) {
            asset = new FreeformBinaryAsset();
        }
        if ((file = this.getFileUploadSection().getFile(event)) != null) {
            try {
                asset.readBytes(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException("Could not find file: " + e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("An error occured: " + e.getMessage());
            }
        }
        String name = (String)this.m_name.getValue(state);
        String desc = (String)this.m_desc.getValue(state);
        if (name == null) {
            name = this.getFileUploadSection().getFileName(event);
        }
        asset.setName(name);
        asset.setDescription(desc);
        return asset;
    }
}

