/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.cms.freeform.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.Asset;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.ui.authoring.TextAssetBody;
import com.arsdigita.db.Sequences;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.london.cms.freeform.FreeformContentItem;
import com.arsdigita.london.cms.freeform.asset.FreeformTextAsset;
import com.arsdigita.london.cms.freeform.ui.ViewAssets;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class FreeformTextAssetEdit
extends TextAssetBody {
    ItemSelectionModel m_FreeformContentItemModel;
    ViewAssets m_viewAssets;
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private TextField m_description;
    private FormInitListener m_ff_InitListener;
    private FormProcessListener m_ff_ProcessListener;

    public FreeformTextAssetEdit(SingleSelectionModel assetModel, ItemSelectionModel itemModel, ViewAssets viewAssets) {
        super(new ItemSelectionModel(assetModel));
        this.m_FreeformContentItemModel = itemModel;
        this.m_viewAssets = viewAssets;
    }

    protected TextAsset createTextAsset(PageState ps) {
        FreeformTextAsset t = new FreeformTextAsset();
        try {
            BigDecimal assetID = Sequences.getNextValue();
            t.setID(assetID);
            t.setName(((ContentItem)this.m_FreeformContentItemModel.getSelectedObject(ps)).getName() + "_freeform_text_" + assetID);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new UncheckedWrapperException((Throwable)ex);
        }
        FreeformContentItem item = (FreeformContentItem)this.m_FreeformContentItemModel.getSelectedObject(ps);
        t.save();
        item.addAsset((Asset)t, new Integer(0));
        item.save();
        return t;
    }

    protected void setMimeTypeOptions(SingleSelect mimeSelect) {
        mimeSelect.addOption(new Option("text/html", "HTML Text"));
        mimeSelect.addOption(new Option("text/gopher", "Gopher Text"));
        mimeSelect.setOptionSelected("text/html");
    }

    protected void updateTextAsset(PageState ps, TextAsset a) {
        a.setParent((ACSObject)((ContentItem)this.m_FreeformContentItemModel.getSelectedObject(ps)));
        a.save();
        this.m_viewAssets.onlyShowComponent(ps, "atk");
    }

    protected void addFileWidgets(TextAssetBody.PageFileForm f) {
        super.addFileWidgets(f);
    }

    protected void addTextWidgets(TextAssetBody.PageTextForm t) {
        this.m_ff_InitListener = new FormInitListener(){

            public void init(FormSectionEvent fse) throws FormProcessException {
                PageState ps = fse.getPageState();
                TextAsset asset = FreeformTextAssetEdit.this.getTextAsset(ps);
                if (asset != null) {
                    FreeformTextAssetEdit.this.m_description.setValue(ps, (Object)asset.getDescription());
                }
            }
        };
        this.m_ff_ProcessListener = new FormProcessListener(){

            public void process(FormSectionEvent fse) throws FormProcessException {
                PageState ps = fse.getPageState();
                TextAsset asset = FreeformTextAssetEdit.this.getTextAsset(ps);
                asset.setDescription((String)FreeformTextAssetEdit.this.m_description.getValue(ps));
                asset.save();
            }
        };
        this.m_description = new TextField((ParameterModel)new StringParameter(DESCRIPTION));
        t.add((Component)new Label("<p>Description:&nbsp;&nbsp; ", false));
        t.add((Component)this.m_description);
        super.addTextWidgets(t);
        t.add((Component)new FormErrorDisplay((Form)t), 65);
        t.addInitListener(this.m_ff_InitListener);
        t.addProcessListener(this.m_ff_ProcessListener);
    }
}

