/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.cms.freeform.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.london.cms.freeform.ui.PaginationTable;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.util.LockableImpl;

public abstract class PaginationTableModelBuilder
extends LockableImpl
implements TableModelBuilder,
PaginationModelBuilder {
    private PaginationTable m_table;
    private RequestLocal m_query = new RequestLocal();
    private RequestLocal m_size = new RequestLocal();

    protected void setPaginationTable(PaginationTable table) {
        this.m_table = table;
    }

    public PaginationTable getPaginationTable() {
        return this.m_table;
    }

    public abstract TableModel makeModel(Table var1, PageState var2);

    public abstract DataQuery makeDataQuery(Paginator var1, PageState var2);

    public DataQuery getFilteredDataQuery(Paginator paginator, PageState state) {
        DataQuery query = this.getDataQuery(paginator, state);
        if (query != null && paginator != null) {
            query.setRange(new Integer(paginator.getFirst(state)), new Integer(paginator.getLast(state) + 1));
        }
        return query;
    }

    public int getTotalSize(Paginator paginator, PageState state) {
        Integer size = (Integer)this.m_size.get(state);
        if (size == null) {
            DataQuery query = this.getDataQuery(paginator, state);
            if (query == null) {
                return 0;
            }
            size = new Integer((int)query.size());
            this.m_size.set(state, (Object)size);
        }
        return size;
    }

    private DataQuery getDataQuery(Paginator paginator, PageState state) {
        DataQuery query = (DataQuery)this.m_query.get(state);
        if (query == null) {
            query = this.makeDataQuery(paginator, state);
            if (query == null) {
                return null;
            }
            if (this.m_table != null) {
                this.m_table.fireQueryPending(query, state);
            }
            this.m_query.set(state, (Object)query);
        }
        return query;
    }
}

