/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.cms.freeform.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.cms.Asset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.london.cms.freeform.FreeformContentItem;
import com.arsdigita.london.cms.freeform.asset.FreeformBinaryAsset;
import com.arsdigita.london.cms.freeform.ui.FreeformAssetTable;
import com.arsdigita.london.cms.freeform.ui.FreeformAssetView;
import com.arsdigita.london.cms.freeform.ui.FreeformBinaryAssetEdit;
import com.arsdigita.london.cms.freeform.ui.FreeformTextAssetEdit;
import com.arsdigita.london.cms.freeform.ui.ResettableContainer;
import com.arsdigita.mimetypes.MimeType;

public class ViewAssets
extends ResettableContainer {
    public static final String ASSET_TABLE_KEY = "atk";
    public static final String ASSET_VIEW_KEY = "avk";
    public static final String TEXT_ASSET_EDIT_KEY = "taek";
    public static final String BINARY_ASSET_EDIT_KEY = "baek";
    private AuthoringKitWizard m_kitWizard;
    private ItemSelectionModel m_itemModel;
    private ItemSelectionModel m_assetModel;
    private FreeformAssetTable m_assetTable;
    private FreeformAssetView m_assetView;
    private FreeformTextAssetEdit m_textAssetEdit;
    private FreeformBinaryAssetEdit m_binaryAssetEdit;

    public ViewAssets(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        this.m_itemModel = itemModel;
        this.m_kitWizard = parent;
        this.add((Component)this.buildTablePanel(), true);
        this.add((Component)this.buildViewPanel(), false);
        this.add((Component)this.buildTextEditPanel(), false);
        this.add((Component)this.buildBinaryEditPanel(), false);
    }

    protected Container buildTablePanel() {
        ColumnPanel c = new ColumnPanel(1);
        c.setKey(ASSET_TABLE_KEY);
        c.setBorderColor("#ffffff");
        c.setPadColor("#ffffff");
        c.add((Component)new Label("Assets", false));
        c.add((Component)new Label("<p>", false));
        this.m_assetTable = new FreeformAssetTable(this.m_itemModel);
        this.m_assetTable.setClassAttr("dataTable");
        this.m_assetModel = new ItemSelectionModel(this.m_assetTable.getRowSelectionModel());
        Label emptyView = new Label("No assets");
        emptyView.setFontWeight("i");
        this.m_assetTable.setEmptyView((Component)emptyView);
        this.m_assetTable.addTableActionListener(new TableActionListener(){

            public void cellSelected(TableActionEvent event) {
                TableColumn tc = ViewAssets.this.m_assetTable.getColumnModel().get(event.getColumn().intValue());
                String columnName = (String)tc.getHeaderValue();
                if ("Name".equals(columnName)) {
                    ViewAssets.this.onlyShowComponent(event.getPageState(), ViewAssets.ASSET_VIEW_KEY);
                }
            }

            public void headSelected(TableActionEvent event) {
            }
        });
        Paginator pgntr = new Paginator(this.m_assetTable.getPaginationModelBuilder(), 5);
        this.m_assetTable.setPaginator(pgntr);
        c.add((Component)pgntr);
        c.add((Component)this.m_assetTable);
        c.add((Component)new Label("<p>", false));
        ActionLink addLink = new ActionLink("Add text asset");
        addLink.setClassAttr("actionLink");
        addLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                ViewAssets.this.m_assetModel.clearSelection(state);
                ViewAssets.this.onlyShowComponent(state, ViewAssets.TEXT_ASSET_EDIT_KEY);
            }
        });
        c.add((Component)addLink);
        addLink = new ActionLink("Add binary asset");
        addLink.setClassAttr("actionLink");
        addLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                ViewAssets.this.m_assetModel.clearSelection(state);
                ViewAssets.this.onlyShowComponent(state, ViewAssets.BINARY_ASSET_EDIT_KEY);
            }
        });
        c.add((Component)addLink);
        return c;
    }

    protected Container buildViewPanel() {
        ColumnPanel c = new ColumnPanel(1);
        c.setKey(ASSET_VIEW_KEY);
        c.setBorderColor("#ffffff");
        c.setPadColor("#ffffff");
        this.m_assetView = new FreeformAssetView((SingleSelectionModel)this.m_assetModel, this.m_itemModel);
        c.add((Component)this.m_assetView);
        ActionLink editLink = new ActionLink("Edit asset");
        editLink.setClassAttr("actionLink");
        editLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                Asset asset = (Asset)ViewAssets.this.m_assetModel.getSelectedObject(state);
                MimeType mimeType = asset.getMimeType();
                String type = mimeType == null ? "unknown" : mimeType.getMimeType();
                if (type.equals("text/html") || type.equals("text/gopher")) {
                    ViewAssets.this.onlyShowComponent(state, ViewAssets.TEXT_ASSET_EDIT_KEY);
                } else {
                    ViewAssets.this.onlyShowComponent(state, ViewAssets.BINARY_ASSET_EDIT_KEY);
                }
            }
        });
        c.add((Component)editLink);
        ActionLink viewAllLink = new ActionLink("View all assets");
        viewAllLink.setClassAttr("actionLink");
        viewAllLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ViewAssets.this.onlyShowComponent(event.getPageState(), ViewAssets.ASSET_TABLE_KEY);
            }
        });
        c.add((Component)viewAllLink);
        return c;
    }

    protected Container buildTextEditPanel() {
        ColumnPanel c = new ColumnPanel(1);
        c.setKey(TEXT_ASSET_EDIT_KEY);
        c.setBorderColor("#ffffff");
        c.setPadColor("#ffffff");
        c.add((Component)new Label(new PrintListener(){

            public void prepare(PrintEvent event) {
                PageState state = event.getPageState();
                Label label = (Label)event.getTarget();
                if (ViewAssets.this.m_assetModel.getSelectedKey(state) == null) {
                    label.setLabel("Add Text Asset");
                } else {
                    label.setLabel("Edit Text Asset");
                }
            }
        }));
        this.m_textAssetEdit = new FreeformTextAssetEdit((SingleSelectionModel)this.m_assetModel, this.m_itemModel, this);
        c.add((Component)this.m_textAssetEdit);
        ActionLink viewAllLink = new ActionLink("View all assets");
        viewAllLink.setClassAttr("actionLink");
        viewAllLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ViewAssets.this.onlyShowComponent(event.getPageState(), ViewAssets.ASSET_TABLE_KEY);
            }
        });
        c.add((Component)viewAllLink);
        return c;
    }

    protected Container buildBinaryEditPanel() {
        ColumnPanel c = new ColumnPanel(1);
        c.setKey(BINARY_ASSET_EDIT_KEY);
        c.setBorderColor("#ffffff");
        c.setPadColor("#ffffff");
        c.add((Component)new Label(new PrintListener(){

            public void prepare(PrintEvent event) {
                PageState state = event.getPageState();
                Label label = (Label)event.getTarget();
                if (ViewAssets.this.m_assetModel.getSelectedKey(state) == null) {
                    label.setLabel("Add Binary Asset");
                } else {
                    label.setLabel("Edit Binary Asset");
                }
            }
        }));
        this.m_binaryAssetEdit = new FreeformBinaryAssetEdit((SingleSelectionModel)this.m_assetModel, this.m_itemModel, this);
        c.add((Component)this.m_binaryAssetEdit);
        this.m_binaryAssetEdit.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent event) throws FormProcessException {
                FreeformBinaryAsset asset;
                PageState state = event.getPageState();
                if (!ViewAssets.this.m_binaryAssetEdit.getCancelButton().isSelected(state) && (asset = ViewAssets.this.m_binaryAssetEdit.getBinaryAsset(event)) != null) {
                    asset.save();
                    FreeformContentItem item = (FreeformContentItem)ViewAssets.this.m_itemModel.getSelectedObject(state);
                    item.addAsset((Asset)asset, new Integer(0));
                    item.save();
                }
                ViewAssets.this.onlyShowComponent(state, ViewAssets.ASSET_TABLE_KEY);
            }
        });
        ActionLink viewAllLink = new ActionLink("View all assets");
        viewAllLink.setClassAttr("actionLink");
        viewAllLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ViewAssets.this.onlyShowComponent(event.getPageState(), ViewAssets.ASSET_TABLE_KEY);
            }
        });
        c.add((Component)viewAllLink);
        return c;
    }
}

