/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.atoz.ui;

import com.arsdigita.atoz.AtoZProvider;
import com.arsdigita.atoz.ui.admin.AbstractProviderForm;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.london.atoz.DomainProvider;
import com.arsdigita.london.terms.Domain;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.util.TooManyListenersException;

public class DomainProviderForm
extends AbstractProviderForm {
    private SingleSelect m_domain;

    public DomainProviderForm(ACSObjectSelectionModel provider) {
        super("domainProvider", DomainProvider.class, provider);
        this.setMetaDataAttribute("title", "Domain provider properties");
    }

    protected void addWidgets() {
        super.addWidgets();
        this.m_domain = new SingleSelect("domain");
        this.m_domain.setMetaDataAttribute("label", "Domain");
        try {
            this.m_domain.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    SingleSelect s = (SingleSelect)e.getTarget();
                    DataCollection domains = SessionManager.getSession().retrieve("com.arsdigita.london.terms.Domain");
                    s.addOption(new Option(null, "-- select one --"));
                    while (domains.next()) {
                        s.addOption(new Option(domains.getDataObject().getOID().toString(), (String)domains.get("title")));
                    }
                }
            });
        }
        catch (TooManyListenersException ex) {
            throw new RuntimeException("cannot happen");
        }
        this.m_domain.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)this.m_domain);
    }

    protected void processWidgets(PageState state, AtoZProvider provider) {
        super.processWidgets(state, provider);
        DomainProvider myprovider = (DomainProvider)provider;
        String oid = (String)this.m_domain.getValue(state);
        myprovider.setDomain((Domain)DomainObjectFactory.newInstance((OID)OID.valueOf((String)oid)));
    }

    protected void initWidgets(PageState state, AtoZProvider provider) {
        super.initWidgets(state, provider);
        DomainProvider myprovider = (DomainProvider)provider;
        if (provider != null) {
            Domain domain = myprovider.getDomain();
            this.m_domain.setValue(state, (Object)domain.getOID().toString());
        }
    }
}

