/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.InlineSite;
import com.arsdigita.cms.contenttypes.ui.InlineSitePropertiesStep;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.util.GlobalizationUtil;

public class InlineSitePropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener {
    private TextField m_url;
    private TextArea m_description;
    private InlineSitePropertiesStep m_step;

    public InlineSitePropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public InlineSitePropertyForm(ItemSelectionModel itemModel, InlineSitePropertiesStep step) {
        super("inlineSiteEdit", itemModel);
        this.m_step = step;
    }

    protected void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.description")));
        this.m_description = new TextArea("pageDescription");
        this.m_description.setCols(30);
        this.m_description.setRows(5);
        if (ContentSection.getConfig().mandatoryDescriptions()) {
            this.m_description.addValidationListener((ParameterListener)new NotEmptyValidationListener(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.description_missing")));
        }
        this.m_description.addValidationListener((ParameterListener)new StringInRangeValidationListener(0, 4000));
        this.add((Component)this.m_description);
        this.add((Component)new Label("URL:"));
        StringParameter urlParam = new StringParameter("url");
        this.m_url = new TextField((ParameterModel)urlParam);
        this.m_url.setSize(40);
        this.add((Component)this.m_url);
    }

    public void init(FormSectionEvent fse) {
        InlineSite site = (InlineSite)super.initBasicWidgets(fse);
        this.m_url.setValue(fse.getPageState(), (Object)site.getURL());
        this.m_description.setValue(fse.getPageState(), (Object)site.getDescription());
    }

    public void process(FormSectionEvent fse) {
        InlineSite site = (InlineSite)super.processBasicWidgets(fse);
        if (site != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            site.setURL((String)this.m_url.getValue(fse.getPageState()));
            site.setDescription((String)this.m_description.getValue(fse.getPageState()));
            site.save();
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}

