/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.webpage;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Webpage
extends ContentPage {
    private static final Logger s_log = Logger.getLogger(Webpage.class);
    public static final String DESCRIPTION = "description";
    public static final String BODY = "body";
    public static final String AUTHOR = "author";
    public static final String CREATOR = "creator";
    public static final String LAST_MOD_LOCAL = "lastModifiedTimeCached";
    public static final String AUTHOR_LAST_NAME = "authorLastName";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.webpage.Webpage";
    public static final String TYPE = "com.arsdigita.cms.webpage.Webpage";
    private boolean m_wasNew;

    public Webpage() {
        this("com.arsdigita.cms.webpage.Webpage");
        try {
            this.setContentType(ContentType.findByAssociatedObjectType((String)"com.arsdigita.cms.webpage.Webpage"));
        }
        catch (DataObjectNotFoundException e) {
            throw new UncheckedWrapperException((String)GlobalizationUtil.globalize((String)"cms.contenttypes.event_type_not_registered").localize(), (Throwable)e);
        }
    }

    public Webpage(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID("com.arsdigita.cms.webpage.Webpage", (Object)id));
    }

    public Webpage(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public Webpage(DataObject obj) {
        super(obj);
    }

    public Webpage(String type) {
        super(type);
    }

    public static Webpage retrieveWebpage(DataObject documentData) {
        Webpage document = (Webpage)DomainObjectFactory.newInstance((DataObject)documentData);
        if (document == null) {
            throw new RuntimeException("Domain object factory produced null document for data object " + documentData);
        }
        return document;
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    public String getBody() {
        return (String)this.get(BODY);
    }

    public void setBody(String body) {
        this.set(BODY, body);
    }

    public User getCreator() {
        if (this.get(CREATOR) == null) {
            return null;
        }
        return new User((DataObject)this.get(CREATOR));
    }

    public void setCreator(User creator) {
        this.set(CREATOR, creator);
    }

    public Date getLastModifiedLocal() {
        return (Date)this.get(LAST_MOD_LOCAL);
    }

    public void setLastModifiedLocal(Date last) {
        this.set(LAST_MOD_LOCAL, last);
    }

    public String getImpliedAuthor() {
        if (this.getAuthor() == null) {
            if (this.getCreator() == null) {
                return "";
            }
            return this.getCreator().getName();
        }
        return this.getAuthor();
    }

    public String getAuthor() {
        return (String)this.get(AUTHOR);
    }

    public void setAuthor(String author) {
        if (author != null && this.getCreationUser() != null && author.equals(this.getCreationUser().getName())) {
            this.set(AUTHOR, null);
            this.setAuthorLastName(null);
        }
        this.set(AUTHOR, author);
        String[] chunks = StringUtils.split((String)author, (char)' ');
        if (chunks.length > 0) {
            this.setAuthorLastName(chunks[chunks.length - 1]);
        } else {
            this.setAuthorLastName(null);
        }
    }

    public String getAuthorLastName() {
        return (String)this.get(AUTHOR_LAST_NAME);
    }

    private void setAuthorLastName(String authorLastName) {
        this.set(AUTHOR_LAST_NAME, authorLastName);
    }

    public void setTitle(String title) {
        this.setName(URLEncoder.encode(title));
        super.setTitle(title);
    }

    public boolean isFolder() {
        return false;
    }

    public boolean isFile() {
        return true;
    }

    public URL toURL() {
        throw new UnsupportedOperationException();
    }

    public boolean isRoot() {
        return false;
    }

    protected void beforeSave() {
        super.beforeSave();
        if (this.isNew()) {
            s_log.debug((Object)((Object)((Object)this) + "newly created Webpage"));
            this.m_wasNew = true;
        }
        if (this.m_wasNew) {
            this.setCreator(this.getCreationUser());
        }
    }

    public void setCategories(String[] catIDs) {
        HashSet<String> newCategories = new HashSet<String>();
        if (catIDs != null) {
            for (int i = 0; i < catIDs.length; ++i) {
                newCategories.add(catIDs[i]);
                s_log.debug((Object)("newCategories: " + catIDs[i]));
            }
        }
        CategoryCollection old = this.getCategoryCollection();
        while (old.next()) {
            Category cat = old.getCategory();
            String catID = cat.getID().toString();
            if (newCategories.contains(catID)) {
                newCategories.remove(catID);
                continue;
            }
            this.removeCategory(cat);
        }
        Iterator additions = newCategories.iterator();
        while (additions.hasNext()) {
            this.addCategory(new Category(new BigDecimal((String)additions.next())));
        }
    }

    public Folder.ItemCollection getWebpagesWithName(Folder parentFolder, String name) {
        Folder.ItemCollection ic = parentFolder.getItems();
        ic.addEqualsFilter("name", (Object)name);
        return ic;
    }
}

