/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.webpage.installer;

import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.cms.webpage.Webpage;
import com.arsdigita.cms.webpage.WebpageConfig;
import com.arsdigita.cms.webpage.ui.WebpagePortlet;
import com.arsdigita.cms.webpage.ui.WebpagePortletEditor;
import com.arsdigita.db.DbHelper;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ResourceTypeConfig;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.portal.PortletSetup;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.DomainInitEvent;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.util.Assert;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class Initializer
extends CompoundInitializer {
    private static Logger s_log = Logger.getLogger((String)Initializer.class.getName());
    private static final WebpageConfig s_config = new WebpageConfig();

    public Initializer() {
        String url = RuntimeConfig.getConfig().getJDBCURL();
        int database = DbHelper.getDatabaseFromURL((String)url);
    }

    public void init(DomainInitEvent e) {
        super.init(e);
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.cms.webpage.Webpage", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Webpage(dataObject);
            }
        });
        this.startup();
    }

    public static WebpageConfig getConfig() {
        return s_config;
    }

    public void startup() {
        WebpageConfig config = Initializer.getConfig();
        String section = config.getContentSection();
        Assert.isTrue((section != null ? 1 : 0) != 0, (String)"contentSection is null");
        config.setContentSection(section);
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        this.loadWebpagePortlet();
        txn.commitTxn();
    }

    public void shutdown() {
    }

    private void loadWebpagePortlet() {
        PortletSetup setup = new PortletSetup((Category)s_log);
        setup.setPortletObjectType("com.arsdigita.cms.webpage.ui.WebpagePortlet");
        setup.setTitle("Webpage");
        setup.setDescription("Displays a webpage");
        setup.setProfile("wide");
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new WebpagePortlet(dataObject);
            }
        });
        setup.run();
        new ResourceTypeConfig("com.arsdigita.cms.webpage.ui.WebpagePortlet"){

            public ResourceConfigFormSection getCreateFormSection(ResourceType resType, RequestLocal parentAppRL) {
                WebpagePortletEditor config = new WebpagePortletEditor(resType, parentAppRL);
                return config;
            }

            public ResourceConfigFormSection getModifyFormSection(RequestLocal application) {
                WebpagePortletEditor config = new WebpagePortletEditor(application);
                return config;
            }
        };
    }

    static {
        s_log.debug((Object)"Static initalizer starting...");
        s_config.load();
        s_log.debug((Object)"Static initalizer finished.");
    }
}

