/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.webpage.tools;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UrlUtil {
    public static String prepareURL(PageState state, String location, ParameterMap params) {
        return UrlUtil.prepareURL(state, location, params, true);
    }

    public static String prepareURL(PageState state, String location, ParameterMap params, boolean includeDispatcherPath) {
        return UrlUtil.prepareURL(state, location, params, includeDispatcherPath, null, false);
    }

    public static String prepareURL(PageState state, String location, ParameterMap params, boolean includeDispatcherPath, String ignoreParam) {
        ArrayList<String> ignoreParams = new ArrayList<String>();
        ignoreParams.add(ignoreParam);
        return UrlUtil.prepareURL(state, location, params, includeDispatcherPath, ignoreParams, false);
    }

    public static String prepareURL(PageState state, String location, ParameterMap params, boolean includeDispatcherPath, List ignoreParams, boolean addPageStateParams) {
        HttpServletRequest req = state.getRequest();
        HttpServletResponse resp = state.getResponse();
        if (params == null) {
            params = new ParameterMap();
        }
        if (addPageStateParams) {
            Iterator stateParams = state.getPage().getParameters();
            while (stateParams.hasNext()) {
                String paramName;
                ParameterModel param = (ParameterModel)stateParams.next();
                Object value = state.getValue(param);
                if (value == null || params.getParameter(paramName = param.getName()) != null) continue;
                params.setParameter(paramName, value);
            }
        }
        params.runListeners(req);
        if (includeDispatcherPath && location.startsWith("/")) {
            location = URL.getDispatcherPath() + location;
        }
        String url = location.indexOf("?") == -1 ? resp.encodeURL(location + params) : (location.endsWith("&") ? resp.encodeURL(location + params.getQueryString()) : resp.encodeURL(location + "&" + params.getQueryString()));
        if (ignoreParams != null) {
            for (String ignoreParam : ignoreParams) {
                url = UrlUtil.removeParameter(url, ignoreParam);
            }
        }
        return url;
    }

    public static String removeParameter(String url, String parameter) {
        Pattern p = Pattern.compile("[?&]" + parameter + "=[^&]*");
        Matcher m = p.matcher(url);
        int index = 0;
        int lastIndex = 0;
        int length = url.length();
        StringBuffer out = new StringBuffer();
        while (m.find(index)) {
            index = m.start();
            int end = m.end();
            if (url.charAt(index) == '&') {
                out.append(url.substring(lastIndex, index));
            } else {
                out.append(url.substring(lastIndex, index + 1));
                if (length > end && url.charAt(end) == '&') {
                    ++end;
                }
            }
            lastIndex = index = end;
        }
        if (url.length() > lastIndex) {
            out.append(url.substring(lastIndex));
        }
        if ((index = out.length() - 1) >= 0 && out.charAt(index) == '?') {
            out.deleteCharAt(index);
        }
        return out.toString();
    }
}

