/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.webpage.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.ContentPanel;
import com.arsdigita.cms.webpage.Webpage;
import com.arsdigita.kernel.User;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.List;
import org.apache.log4j.Logger;

public class ContentPanelWebpageNode
extends ContentPanel {
    private static final Logger s_log = Logger.getLogger(ContentPanelWebpageNode.class);

    public void generateXML(PageState state, Element parent) {
        ContentSection section = CMS.getContext().getContentSection();
        Assert.exists((Object)section, ContentSection.class);
        if (this.isVisible(state)) {
            super.generateXML(state, parent);
            User user = Web.getContext().getUser();
            SecurityManager sm = new SecurityManager(section);
            if (user != null && sm != null) {
                this.modifyContentPanelElements(parent.getChildren(), section, user, sm);
            }
        }
    }

    private void modifyContentPanelElements(List elements, ContentSection section, User user, SecurityManager sm) {
        s_log.debug((Object)"modifyContentPanelElements - webpage");
        for (int i = 0; elements != null && i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            if (!"cms:contentPanel".equals(element.getName())) continue;
            this.modifyItemElements(element.getChildren(), section, user, sm);
        }
    }

    private void modifyItemElements(List elements, ContentSection section, User user, SecurityManager sm) {
        for (int i = 0; elements != null && i < elements.size(); ++i) {
            StringBuffer onClick;
            Element element = (Element)elements.get(i);
            if (!"cms:item".equals(element.getName()) || !"com.arsdigita.cms.webpage.Webpage".equals(this.getTextOfElement(element.getChildren(), "objectType"))) continue;
            s_log.debug((Object)"found webpage");
            BigDecimal id = null;
            try {
                id = new BigDecimal(this.getTextOfElement(element.getChildren(), "id"));
            }
            catch (Exception e) {
                s_log.error((Object)"modifyItemElements", (Throwable)e);
                continue;
            }
            String sectionURL = section.getURL();
            Webpage webpage = new Webpage(id);
            if (sm.canAccess(user, "edit_item", (ContentItem)webpage)) {
                Element newWebpageElement = element.newChildElement("webpage:button", "http://www.undp.org/webpage/1.0");
                newWebpageElement.addAttribute("name", "_ew");
                newWebpageElement.addAttribute("value", "Edit webpage");
                onClick = new StringBuffer();
                onClick.append("location.href='").append(sectionURL);
                if (!sectionURL.endsWith("/")) {
                    onClick.append("/");
                }
                onClick.append("cmsWebpageEdit.jsp?");
                onClick.append("id").append("=").append(id.toString());
                onClick.append("';");
                newWebpageElement.addAttribute("onClick", onClick.toString());
            }
            Element previewWebpageElement = element.newChildElement("webpage:button", "http://www.undp.org/webpage/1.0");
            previewWebpageElement.addAttribute("name", "_pw");
            previewWebpageElement.addAttribute("value", "Preview webpage");
            onClick = new StringBuffer();
            onClick.append("location.href='").append(sectionURL);
            if (!sectionURL.endsWith("/")) {
                onClick.append("/");
            }
            onClick.append("cmsWebpagePreview.jsp?");
            onClick.append("id").append("=").append(id.toString());
            onClick.append("';");
            previewWebpageElement.addAttribute("onClick", onClick.toString());
        }
    }

    private String getTextOfElement(List elements, String elementName) {
        if (elements != null && elementName != null) {
            for (int i = 0; i < elements.size(); ++i) {
                Element element = (Element)elements.get(i);
                if (!elementName.equals(element.getName())) continue;
                return element.getText();
            }
        }
        return null;
    }
}

