/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.webpage.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Date;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.MultipleSelect;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionServlet;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.LifecycleDefinitionCollection;
import com.arsdigita.cms.lifecycle.Phase;
import com.arsdigita.cms.lifecycle.PhaseCollection;
import com.arsdigita.cms.ui.CMSDHTMLEditor;
import com.arsdigita.cms.webpage.Webpage;
import com.arsdigita.cms.webpage.WebpageConstants;
import com.arsdigita.cms.webpage.ui.AuthorLabelPrinter;
import com.arsdigita.cms.webpage.ui.CategoriesPrintListener;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Engine;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import com.arsdigita.xml.Document;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class WebpageCMSEditorPage
extends CMSPage
implements WebpageConstants {
    private static final Logger s_log = Logger.getLogger(WebpageCMSEditorPage.class);
    private WebpageCMSEditorForm m_createForm;
    private WebpageCMSEditorForm m_editForm;

    public WebpageCMSEditorPage() {
        super("Story Editor", (Container)new SimpleContainer());
        SimpleContainer header = new SimpleContainer("webpage:header", "http://www.undp.org/webpage/1.0");
        SimpleContainer body = new SimpleContainer("webpage:body", "http://www.undp.org/webpage/1.0");
        SimpleContainer footer = new SimpleContainer("webpage:footer", "http://www.undp.org/webpage/1.0");
        this.m_createForm = new WebpageCMSEditorForm(true);
        this.m_editForm = new WebpageCMSEditorForm(false);
        body.add((Component)this.m_createForm);
        body.add((Component)this.m_editForm);
        this.add((Component)header);
        this.add((Component)body);
        this.add((Component)footer);
    }

    protected void buildPage() {
        super.buildPage();
        this.setClassAttr("webpage");
    }

    public void generateXML(PageState state, Document parent) {
        BigDecimal id = null;
        try {
            HttpServletRequest request = state.getRequest();
            id = new BigDecimal(request.getParameter("id"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.m_createForm.setVisible(state, id == null);
        this.m_editForm.setVisible(state, id != null);
        super.generateXML(state, parent);
    }

    public class WebpageCMSEditorForm
    extends Form
    implements FormInitListener,
    FormValidationListener,
    FormProcessListener {
        Hidden m_itemID;
        TextField m_author;
        TextField m_title;
        MultipleSelect m_categories;
        CMSDHTMLEditor m_body;
        CMSDHTMLEditor m_desc;
        Submit m_save;
        Date m_startDate;
        TextField m_startHour;
        TextField m_startMinute;
        SingleSelect m_startAmpm;
        Date m_endDate;
        TextField m_endHour;
        TextField m_endMinute;
        SingleSelect m_endAmpm;
        boolean m_displayDates;

        public WebpageCMSEditorForm(boolean displayDates) {
            super("WebpageCMSEditorForm");
            this.m_displayDates = displayDates;
            this.m_title = new TextField((ParameterModel)new StringParameter("title"));
            this.m_title.setSize(35);
            this.add((Component)new Label("Title:"), 12);
            this.add((Component)this.m_title);
            this.m_author = new TextField("author");
            this.add((Component)new Label((PrintListener)new AuthorLabelPrinter()), 12);
            this.add((Component)this.m_author);
            this.m_desc = new CMSDHTMLEditor("desc");
            this.m_desc.setRows(10);
            this.m_desc.setCols(80);
            this.add((Component)new Label("Lead:", false), 12);
            this.add((Component)this.m_desc);
            this.add((Component)new Label("Location:"), 12);
            this.m_categories = new MultipleSelect("categories");
            this.m_categories.setSize(5);
            this.add((Component)this.m_categories);
            this.add((Component)new Label("Body:"), 12);
            StringParameter bodyParam = new StringParameter("body");
            this.m_body = new CMSDHTMLEditor((ParameterModel)bodyParam);
            this.m_body.setCols(80);
            this.m_body.setRows(20);
            this.add((Component)this.m_body);
            if (displayDates) {
                this.add((Component)new Label("Start date:"), 12);
                this.m_startDate = new Date((ParameterModel)new DateParameter("start_date"){

                    protected final Calendar getCalendar(HttpServletRequest sreq) {
                        Calendar cal = super.getCalendar(sreq);
                        cal.setLenient(false);
                        return cal;
                    }
                });
                this.add((Component)this.m_startDate);
                this.add((Component)new Label("Start time:"), 12);
                BoxPanel startTime = new BoxPanel(1);
                this.m_startHour = new TextField((ParameterModel)new IntegerParameter("start_hour"));
                this.m_startHour.setSize(3);
                startTime.add((Component)this.m_startHour);
                this.m_startMinute = new TextField((ParameterModel)new IntegerParameter("start_minute"));
                this.m_startMinute.setSize(3);
                startTime.add((Component)this.m_startMinute);
                this.m_startAmpm = new SingleSelect((ParameterModel)new IntegerParameter("start_ampm"));
                this.m_startAmpm.addOption(new Option("0", "am"));
                this.m_startAmpm.addOption(new Option("1", "pm"));
                startTime.add((Component)this.m_startAmpm);
                startTime.add((Component)new Label((PrintListener)new TimeZonePrinter()));
                this.add((Component)startTime);
                this.add((Component)new Label("End date:"), 12);
                this.m_endDate = new Date((ParameterModel)new DateParameter("end_date"){

                    protected final Calendar getCalendar(HttpServletRequest sreq) {
                        Calendar cal = super.getCalendar(sreq);
                        cal.setLenient(false);
                        return cal;
                    }
                });
                this.add((Component)this.m_endDate);
                this.add((Component)new Label("End time:"), 12);
                BoxPanel endTime = new BoxPanel(1);
                this.m_endHour = new TextField((ParameterModel)new IntegerParameter("end_hour"));
                this.m_endHour.setSize(3);
                endTime.add((Component)this.m_endHour);
                this.m_endMinute = new TextField((ParameterModel)new IntegerParameter("end_minute"));
                this.m_endMinute.setSize(3);
                endTime.add((Component)this.m_endMinute);
                this.m_endAmpm = new SingleSelect((ParameterModel)new IntegerParameter("end_ampm"));
                this.m_endAmpm.addOption(new Option("0", "am"));
                this.m_endAmpm.addOption(new Option("1", "pm"));
                endTime.add((Component)this.m_endAmpm);
                endTime.add((Component)new Label((PrintListener)new TimeZonePrinter()));
                this.add((Component)endTime);
            }
            this.m_itemID = new Hidden("id");
            this.add((Component)this.m_itemID);
            SimpleContainer buttons = new SimpleContainer();
            this.m_save = new Submit("Save");
            buttons.add((Component)this.m_save);
            buttons.add((Component)new Label(""));
            buttons.add((Component)new Submit("Cancel"));
            this.add((Component)new Label(""));
            this.add((Component)buttons);
            this.addInitListener(this);
            this.addValidationListener(this);
            this.addProcessListener(this);
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            s_log.debug((Object)"init");
            PageState state = e.getPageState();
            HttpServletRequest request = state.getRequest();
            ContentSection section = ContentSectionServlet.getContentSection((HttpServletRequest)request);
            Webpage webpage = null;
            try {
                BigDecimal id = new BigDecimal(request.getParameter("id"));
                webpage = new Webpage(id);
                if (!webpage.getContentSection().equals((Object)section)) {
                    s_log.error((Object)"content section doesn't match! create new webpage entity.");
                    webpage = null;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_categories.setPrintListener((PrintListener)new CategoriesPrintListener(section));
            if (webpage != null) {
                this.m_itemID.setValue(state, (Object)webpage.getID().toString());
                this.m_author.setValue(state, (Object)webpage.getAuthor());
                this.m_title.setValue(state, (Object)webpage.getTitle());
                this.m_desc.setValue(state, (Object)webpage.getDescription());
                this.m_body.setValue(state, (Object)webpage.getBody());
                ArrayList<String> assignedCats = new ArrayList<String>();
                CategoryCollection cc = webpage.getCategoryCollection();
                while (cc.next()) {
                    String catID = cc.getCategory().getID().toString();
                    assignedCats.add(catID);
                }
                this.m_categories.setValue(state, (Object)assignedCats.toArray());
            } else {
                this.m_categories.setValue(state, (Object)new String[]{request.getParameter("categoryID")});
                if (this.m_displayDates) {
                    java.util.Date start = new java.util.Date(System.currentTimeMillis());
                    this.m_startDate.setValue(state, (Object)start);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(start);
                    if (calendar.get(10) == 0) {
                        this.m_startHour.setValue(state, (Object)new Integer(12));
                    } else {
                        this.m_startHour.setValue(state, (Object)new Integer(calendar.get(10)));
                    }
                    Integer min = new Integer(calendar.get(12));
                    if (min < 10) {
                        this.m_startMinute.setValue(state, (Object)("0" + min.toString()));
                    } else {
                        this.m_startMinute.setValue(state, (Object)min.toString());
                    }
                    this.m_startAmpm.setValue(state, (Object)new Integer(calendar.get(9)));
                }
            }
        }

        public void validate(FormSectionEvent e) throws FormProcessException {
            s_log.debug((Object)"validate");
            PageState state = e.getPageState();
            boolean valid = true;
            if (this.m_save.isSelected(state)) {
                String desc;
                String title = (String)this.m_title.getValue(state);
                if (title == null || title.length() == 0) {
                    this.m_title.addError("This parameter is required");
                    valid = false;
                }
                if (title != null && (title.length() < 1 || title.length() > 200)) {
                    this.m_title.addError("This parameter is not between 1 and 200 characters long");
                    valid = false;
                }
                if ((desc = (String)this.m_desc.getValue(state)) != null && (desc.length() < 1 || desc.length() > 4000)) {
                    this.m_desc.addError("This parameter is not between 1 and 4000 characters long");
                    valid = false;
                }
                if (this.m_displayDates) {
                    Integer endMin;
                    Integer endHour;
                    Integer startMin;
                    Integer startHour = (Integer)this.m_startHour.getValue(state);
                    if (startHour != null && (startHour < 1 || startHour > 12)) {
                        this.m_startHour.addError("This parameter is not between 1 and 12");
                        valid = false;
                    }
                    if ((startMin = (Integer)this.m_startMinute.getValue(state)) != null && (startMin < 0 || startMin > 59)) {
                        this.m_startMinute.addError("This parameter is not between 0 and 59");
                        valid = false;
                    }
                    if ((endHour = (Integer)this.m_endHour.getValue(state)) != null && (endHour < 1 || endHour > 12)) {
                        this.m_endHour.addError("This parameter is not between 1 and 12");
                        valid = false;
                    }
                    if ((endMin = (Integer)this.m_endMinute.getValue(state)) != null && (endMin < 0 || endMin > 59)) {
                        this.m_endMinute.addError("This parameter is not between 0 and 59");
                        valid = false;
                    }
                }
            }
            if (!valid) {
                throw new FormProcessException("There is an error on the form");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(FormSectionEvent e) throws FormProcessException {
            s_log.debug((Object)"process");
            PageState state = e.getPageState();
            HttpServletRequest request = state.getRequest();
            ContentSection section = ContentSectionServlet.getContentSection((HttpServletRequest)request);
            if (this.m_save.isSelected(state)) {
                Webpage webpage = null;
                boolean commitTransaction = false;
                boolean isMyTransaction = false;
                TransactionContext txn = null;
                try {
                    Session session = SessionManager.getSession();
                    txn = session.getTransactionContext();
                    if (!txn.inTxn()) {
                        txn.beginTxn();
                        isMyTransaction = true;
                    }
                    try {
                        String idTxt = (String)this.m_itemID.getValue(state);
                        if (idTxt != null && idTxt.length() > 0) {
                            BigDecimal id = new BigDecimal(idTxt);
                            webpage = new Webpage(id);
                        }
                    }
                    catch (Exception ex) {
                        throw new FormProcessException((Throwable)ex);
                    }
                    if (section == null) {
                        throw new FormProcessException("ContentSection is null");
                    }
                    SecurityManager sm = new SecurityManager(section);
                    User user = Web.getContext().getUser();
                    if (webpage != null) {
                        if (!sm.canAccess(user, "edit_item", (ContentItem)webpage)) {
                            throw new FormProcessException("Insufficient permissions");
                        }
                        if (!webpage.getContentSection().equals((Object)section)) {
                            throw new FormProcessException("content section doesn't match!");
                        }
                        webpage.setTitle((String)this.m_title.getValue(state));
                        webpage.setName("webpage" + webpage.getID());
                        webpage.setBody((String)this.m_body.getValue(state));
                        webpage.setAuthor((String)this.m_author.getValue(state));
                        webpage.setCategories((String[])this.m_categories.getValue(state));
                        webpage.setDescription((String)this.m_desc.getValue(state));
                        webpage.save();
                    } else {
                        if (!sm.canAccess((Party)user, "new_item")) {
                            throw new FormProcessException("Insufficient permissions");
                        }
                        webpage = new Webpage();
                        webpage.setLanguage("en");
                        webpage.setName("webpage" + webpage.getID());
                        webpage.setTitle((String)this.m_title.getValue(state));
                        webpage.setBody((String)this.m_body.getValue(state));
                        webpage.setAuthor((String)this.m_author.getValue(state));
                        webpage.setDescription((String)this.m_desc.getValue(state));
                        webpage.save();
                        ContentBundle bundle = new ContentBundle((ContentItem)webpage);
                        bundle.setContentSection(section);
                        bundle.setParent((ACSObject)section.getRootFolder());
                        webpage.setCategories((String[])this.m_categories.getValue(state));
                        LifecycleDefinitionCollection lfColl = null;
                        LifecycleDefinition lifecycleDefinition = null;
                        try {
                            lfColl = section.getLifecycleDefinitions();
                            if (lfColl.next()) {
                                lifecycleDefinition = lfColl.getLifecycleDefinition();
                            }
                        }
                        finally {
                            if (lfColl != null) {
                                lfColl.close();
                            }
                        }
                        TaskCollection taskColl = null;
                        try {
                            taskColl = section.getWorkflowTemplates();
                            if (taskColl.next()) {
                                Task task = taskColl.getTask();
                                WorkflowTemplate wfTemp = new WorkflowTemplate(task.getID());
                                Workflow flow = wfTemp.instantiateNewWorkflow();
                                flow.setObjectID(webpage.getID());
                                flow.start(Web.getContext().getUser());
                                flow.save();
                            }
                        }
                        finally {
                            if (taskColl != null) {
                                taskColl.close();
                            }
                        }
                        Workflow workflow = Workflow.getObjectWorkflow((ACSObject)webpage);
                        Engine engine = Engine.getInstance();
                        Assert.exists((Object)engine, Engine.class);
                        Iterator i = engine.getEnabledTasks(Web.getContext().getUser(), workflow.getID()).iterator();
                        while (true) {
                            if (i.hasNext()) {
                                CMSTask task = (CMSTask)i.next();
                                try {
                                    task.finish();
                                }
                                catch (Exception ex) {
                                    throw new FormProcessException((Throwable)ex);
                                }
                            }
                            i = engine.getEnabledTasks(Web.getContext().getUser(), workflow.getID()).iterator();
                            if (!i.hasNext()) break;
                        }
                        if (lifecycleDefinition != null) {
                            if (this.m_displayDates) {
                                Integer startHour = (Integer)this.m_startHour.getValue(state);
                                Integer startMinute = (Integer)this.m_startMinute.getValue(state);
                                if (startMinute == null) {
                                    startMinute = new Integer(0);
                                }
                                Integer startAmpm = (Integer)this.m_startAmpm.getValue(state);
                                Integer endHour = (Integer)this.m_endHour.getValue(state);
                                Integer endMinute = (Integer)this.m_endMinute.getValue(state);
                                if (endMinute == null) {
                                    endMinute = new Integer(0);
                                }
                                Integer endAmpm = (Integer)this.m_endAmpm.getValue(state);
                                java.util.Date startDate = (java.util.Date)this.m_startDate.getValue(state);
                                Calendar start = Calendar.getInstance();
                                start.setTime(startDate);
                                start.set(9, startAmpm);
                                start.set(12, startMinute);
                                start.set(9, startAmpm);
                                if (startHour != 12) {
                                    start.set(11, 12 * startAmpm + startHour);
                                    start.set(10, startHour);
                                } else if (startAmpm == 0) {
                                    start.set(11, 0);
                                    start.set(10, 0);
                                } else {
                                    start.set(11, 12);
                                    start.set(10, 0);
                                }
                                startDate = start.getTime();
                                java.util.Date endDate = (java.util.Date)this.m_endDate.getValue(state);
                                if (endDate != null) {
                                    Calendar end = Calendar.getInstance();
                                    end.setTime(endDate);
                                    end.set(9, endAmpm);
                                    end.set(12, endMinute);
                                    end.set(9, endAmpm);
                                    if (endHour != 12) {
                                        end.set(11, 12 * endAmpm + endHour);
                                        end.set(10, endHour);
                                    } else if (endAmpm == 0) {
                                        end.set(11, 0);
                                        end.set(10, 0);
                                    } else {
                                        end.set(11, 12);
                                        end.set(10, 0);
                                    }
                                    endDate = end.getTime();
                                }
                                webpage.publish(lifecycleDefinition, startDate);
                                if (endDate != null) {
                                    Lifecycle lifecycle = webpage.getLifecycle();
                                    PhaseCollection phases = lifecycle.getPhases();
                                    while (phases.next()) {
                                        Phase phase = phases.getPhase();
                                        java.util.Date thisEnd = phase.getEndDate();
                                        if (thisEnd != null && thisEnd.compareTo(endDate) <= 0) continue;
                                        phase.setEndDate(endDate);
                                        phase.save();
                                    }
                                }
                            } else {
                                webpage.publish(lifecycleDefinition, new java.util.Date());
                            }
                            webpage.getLifecycle().start();
                            webpage.save();
                        }
                    }
                    commitTransaction = true;
                }
                finally {
                    if (txn != null && isMyTransaction) {
                        if (commitTransaction) {
                            txn.commitTxn();
                        } else {
                            txn.abortTxn();
                        }
                    }
                }
            }
            try {
                DispatcherHelper.sendRedirect((HttpServletRequest)request, (HttpServletResponse)state.getResponse(), (String)section.getPath());
            }
            catch (IOException ex) {
                throw new FormProcessException((Throwable)ex);
            }
        }

        public class TimeZonePrinter
        implements PrintListener {
            public void prepare(PrintEvent e) {
                Label target = (Label)e.getTarget();
                PageState state = e.getPageState();
                Calendar mStart = Calendar.getInstance();
                java.util.Date st = (java.util.Date)WebpageCMSEditorForm.this.m_startDate.getValue(state);
                if (st != null) {
                    mStart.setTime((java.util.Date)WebpageCMSEditorForm.this.m_startDate.getValue(state));
                }
                String zone = mStart.getTimeZone().getDisplayName(true, 0);
                target.setLabel(zone);
            }
        }
    }
}

