/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.webpage.ui;

import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.cms.lifecycle.LifecycleDefinitionCollection;
import com.arsdigita.cms.webpage.Webpage;
import com.arsdigita.cms.webpage.ui.WebpagePortletRenderer;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Resource;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.portal.Portal;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portalworkspace.WorkspacePage;
import java.util.Date;
import org.apache.log4j.Category;

public class WebpagePortlet
extends Portlet {
    private static Category s_log = Category.getInstance((String)WebpagePortlet.class.getName());
    public static final String WEBPAGE = "webpage";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.webpage.ui.WebpagePortlet";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public WebpagePortlet(DataObject dataObject) {
        super(dataObject);
    }

    public Webpage getWebpage() {
        DataObject obj = (DataObject)this.get(WEBPAGE);
        return obj == null ? null : (Webpage)DomainObjectFactory.newInstance((DataObject)obj);
    }

    public void setWebpage(Webpage webpage) {
        this.setAssociation(WEBPAGE, (DomainObject)webpage);
    }

    protected AbstractPortletRenderer doGetPortletRenderer() {
        return new WebpagePortletRenderer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortal(Portal portal) {
        Webpage webpage;
        super.setPortal(portal);
        if (portal instanceof WorkspacePage) {
            WorkspacePage wPage = (WorkspacePage)portal;
            this.setParentResource((Resource)wPage.getWorkspace());
        }
        if ((webpage = this.getWebpage()) != null && !webpage.isPublished()) {
            try {
                LifecycleDefinitionCollection lfColl = null;
                try {
                    lfColl = webpage.getContentSection().getLifecycleDefinitions();
                    if (lfColl.next()) {
                        webpage.publish(lfColl.getLifecycleDefinition(), new Date());
                        webpage.getLifecycle().start();
                        webpage.save();
                    }
                }
                finally {
                    if (lfColl != null) {
                        lfColl.close();
                    }
                }
            }
            catch (Exception e) {
                s_log.error((Object)"try to publish created webpage", (Throwable)e);
            }
        }
    }
}

