/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.webpage.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.MultipleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.portal.PortletConfigFormSection;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.dispatcher.SimpleItemResolver;
import com.arsdigita.cms.ui.CMSDHTMLEditor;
import com.arsdigita.cms.webpage.Webpage;
import com.arsdigita.cms.webpage.installer.Initializer;
import com.arsdigita.cms.webpage.ui.AuthorLabelPrinter;
import com.arsdigita.cms.webpage.ui.CategoriesPrintListener;
import com.arsdigita.cms.webpage.ui.WebpagePortlet;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.portal.Portlet;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Engine;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class WebpagePortletEditor
extends PortletConfigFormSection {
    private static final Logger s_log = Logger.getLogger(WebpagePortletEditor.class);
    TextField m_author;
    TextField m_title;
    MultipleSelect m_categories;
    CMSDHTMLEditor m_desc;
    CMSDHTMLEditor m_body;

    public WebpagePortletEditor(ResourceType resType, RequestLocal parentAppRL) {
        super(resType, parentAppRL);
    }

    public WebpagePortletEditor(RequestLocal application) {
        super(application);
    }

    public void addWidgets() {
        this.add((Component)new Label("Body:"));
        StringParameter bodyParam = new StringParameter("body");
        this.m_body = new CMSDHTMLEditor((ParameterModel)bodyParam);
        this.m_body.setCols(80);
        this.m_body.setRows(20);
        this.add((Component)this.m_body);
        this.m_title = new TextField((ParameterModel)new StringParameter("title"));
        this.m_title.setSize(35);
        this.m_title.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_title.addValidationListener((ParameterListener)new StringInRangeValidationListener(1, 200));
        this.add((Component)new Label("Title:"));
        this.add((Component)this.m_title);
        this.m_author = new TextField("author");
        this.add((Component)new Label((PrintListener)new AuthorLabelPrinter()));
        this.add((Component)this.m_author);
        this.add((Component)new Label("Categories"));
        this.m_categories = new MultipleSelect("categories");
        this.m_categories.setSize(5);
        try {
            ContentSection section = Initializer.getConfig().getWebpageSection();
            this.m_categories.addPrintListener((PrintListener)new CategoriesPrintListener(section));
        }
        catch (TooManyListenersException tmex) {
            throw new UncheckedWrapperException(tmex.getMessage());
        }
        this.add((Component)this.m_categories);
        this.m_desc = new CMSDHTMLEditor("desc");
        this.m_desc.setRows(20);
        this.m_desc.setCols(80);
        this.m_desc.addValidationListener((ParameterListener)new StringInRangeValidationListener(1, 4000));
        this.add((Component)new Label("Description:<br /><font size=-1>(this field is currently not displayed on the website)</font>", false));
        this.add((Component)this.m_desc);
    }

    public void initWidgets(PageState state, Portlet portlet) throws FormProcessException {
        if (portlet != null) {
            WebpagePortlet myportlet = (WebpagePortlet)portlet;
            SimpleItemResolver resolver = new SimpleItemResolver();
            Webpage webpage = myportlet.getWebpage();
            if (webpage != null) {
                this.m_title.setValue(state, (Object)portlet.getTitle());
                this.m_desc.setValue(state, (Object)portlet.getDescription());
                this.m_body.setValue(state, (Object)webpage.getBody());
                this.m_author.setValue(state, (Object)webpage.getAuthor());
                ArrayList<String> assignedCats = new ArrayList<String>();
                CategoryCollection cc = webpage.getCategoryCollection();
                while (cc.next()) {
                    String catID = cc.getCategory().getID().toString();
                    assignedCats.add(catID);
                }
                this.m_categories.setValue(state, (Object)assignedCats.toArray());
            }
        }
    }

    public void validateWidgets(PageState state, Portlet portlet) throws FormProcessException {
        super.validateWidgets(state, portlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processWidgets(PageState state, Portlet portlet) throws FormProcessException {
        portlet.setTitle((String)this.m_title.getValue(state));
        portlet.setDescription((String)this.m_desc.getValue(state));
        WebpagePortlet myportlet = (WebpagePortlet)portlet;
        Webpage webpage = myportlet.getWebpage();
        boolean commitTransaction = false;
        boolean isMyTransaction = false;
        TransactionContext txn = null;
        try {
            Session session = SessionManager.getSession();
            txn = session.getTransactionContext();
            if (!txn.inTxn()) {
                txn.beginTxn();
                isMyTransaction = true;
            }
            if (webpage == null) {
                ContentSection section = Initializer.getConfig().getWebpageSection();
                if (section == null) {
                    throw new FormProcessException("no such content section");
                }
                Application app = Web.getContext().getApplication();
                String folderName = StringUtils.replace((String)app.getPath(), (String)"/", (String)"-");
                Folder rootFolder = section.getRootFolder();
                Folder folder = (Folder)rootFolder.getItem(folderName, true);
                if (folder == null) {
                    folder = new Folder();
                    folder.setName(folderName);
                    folder.setLabel(folderName);
                    folder.setParent((ACSObject)rootFolder);
                    PermissionService.setContext((ACSObject)folder, (ACSObject)rootFolder);
                    folder.save();
                }
                webpage = new Webpage();
                webpage.setLanguage("en");
                webpage.setTitle(portlet.getTitle());
                webpage.setDescription(portlet.getDescription());
                webpage.setBody((String)this.m_body.getValue(state));
                webpage.setAuthor((String)this.m_author.getValue(state));
                webpage.save();
                ContentBundle bundle = new ContentBundle((ContentItem)webpage);
                bundle.setContentSection(section);
                bundle.setParent((ACSObject)folder);
                webpage.setCategories((String[])this.m_categories.getValue(state));
                TaskCollection taskColl = null;
                try {
                    taskColl = section.getWorkflowTemplates();
                    if (taskColl.next()) {
                        Task task = taskColl.getTask();
                        WorkflowTemplate wfTemp = new WorkflowTemplate(task.getID());
                        Workflow flow = wfTemp.instantiateNewWorkflow();
                        flow.setObjectID(webpage.getID());
                        flow.start(Web.getContext().getUser());
                        flow.save();
                    }
                }
                finally {
                    if (taskColl != null) {
                        taskColl.close();
                    }
                }
                Workflow workflow = Workflow.getObjectWorkflow((ACSObject)webpage);
                Engine engine = Engine.getInstance();
                Assert.exists((Object)engine, Engine.class);
                Iterator i = engine.getEnabledTasks(Web.getContext().getUser(), workflow.getID()).iterator();
                while (true) {
                    if (i.hasNext()) {
                        CMSTask task = (CMSTask)i.next();
                        try {
                            task.finish();
                        }
                        catch (Exception ex) {
                            throw new FormProcessException((Throwable)ex);
                        }
                    }
                    i = engine.getEnabledTasks(Web.getContext().getUser(), workflow.getID()).iterator();
                    if (!i.hasNext()) break;
                }
                myportlet.setWebpage(webpage);
            } else {
                webpage.setTitle(portlet.getTitle());
                webpage.setDescription(portlet.getDescription());
                webpage.setBody((String)this.m_body.getValue(state));
                webpage.setAuthor((String)this.m_author.getValue(state));
                webpage.setCategories((String[])this.m_categories.getValue(state));
                webpage.save();
            }
            commitTransaction = true;
        }
        finally {
            if (txn != null && isMyTransaction) {
                if (commitTransaction) {
                    txn.commitTxn();
                } else {
                    txn.abortTxn();
                }
            }
        }
    }
}

