/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.webpage.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.ui.CMSDHTMLEditor;
import com.arsdigita.cms.webpage.Webpage;
import com.arsdigita.cms.webpage.ui.AuthorLabelPrinter;
import com.arsdigita.cms.webpage.ui.WebpagePortlet;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.portal.Portlet;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class WebpagePortletEditorPage
extends CMSPage {
    public static final Logger s_log = Logger.getLogger(WebpagePortletEditorPage.class);
    public static final String PORTLET_ID = "portletID";
    public static final String CATEGORIES = "categories";

    public WebpagePortletEditorPage() {
        super("Webpage Editor", (Container)new SimpleContainer());
        SimpleContainer header = new SimpleContainer("webpage:header", "http://www.undp.org/webpage/1.0");
        SimpleContainer body = new SimpleContainer("webpage:body", "http://www.undp.org/webpage/1.0");
        SimpleContainer footer = new SimpleContainer("webpage:footer", "http://www.undp.org/webpage/1.0");
        WebpagePortletEditorForm editForm = new WebpagePortletEditorForm();
        DimensionalNavbar navbar = new DimensionalNavbar();
        navbar.setClassAttr("portalNavbar");
        navbar.add((Component)new Link((PrintListener)new CurrentApplicationLinkPrinter(editForm)));
        header.add((Component)navbar);
        body.add((Component)editForm);
        this.add((Component)header);
        this.add((Component)body);
        this.add((Component)footer);
    }

    protected void buildPage() {
        super.buildPage();
        this.setClassAttr("portalserver");
    }

    protected class CurrentApplicationLinkPrinter
    implements PrintListener {
        private final WebpagePortletEditorForm parentEditForm;

        public CurrentApplicationLinkPrinter(WebpagePortletEditorForm aParentEditForm) {
            this.parentEditForm = aParentEditForm;
        }

        public void prepare(PrintEvent e) {
            Link link = (Link)e.getTarget();
            PageState pageState = e.getPageState();
            try {
                WebpagePortlet portlet = this.parentEditForm.getWebpagePortlet(pageState);
                Application app = (Application)portlet.getParentResource();
                link.setChild((Component)new Label(app.getTitle()));
                link.setTarget(app.getPath());
            }
            catch (FormProcessException ex) {
                s_log.error((Object)"CurrentApplicationLinkPrinter.prepare", (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    public class WebpagePortletEditorForm
    extends Form
    implements FormInitListener,
    FormProcessListener {
        private Submit editSubmit1;

        public WebpagePortletEditorForm() {
            super("WebpagePortletEditorForm");
            this.editSubmit1 = new Submit("Edit");
            this.addWidgets();
            this.addInitListener(this);
            this.addProcessListener(this);
        }

        public void addWidgets() {
            this.add((Component)new Label("Body:"));
            StringParameter bodyParam = new StringParameter("body");
            CMSDHTMLEditor body = new CMSDHTMLEditor((ParameterModel)bodyParam);
            body.setCols(80);
            body.setRows(20);
            this.add((Component)body);
            SimpleContainer buttons = new SimpleContainer();
            buttons.add((Component)this.editSubmit1);
            buttons.add((Component)new Label(" "));
            buttons.add((Component)new Submit("Cancel"));
            this.add((Component)buttons);
            this.add((Component)new Label(" "));
            this.add((Component)new Label("Title:"));
            this.add((Component)new TextField("title"));
            this.add((Component)new Label((PrintListener)new AuthorLabelPrinter()));
            this.add((Component)new TextField("author"));
            BigDecimalParameter portletIDParameter = new BigDecimalParameter(WebpagePortletEditorPage.PORTLET_ID);
            this.add((Component)new Hidden((ParameterModel)portletIDParameter));
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            WebpagePortlet portlet = this.getWebpagePortlet(e.getPageState());
            Webpage webpage = portlet.getWebpage();
            data.put((Object)"title", (Object)webpage.getTitle());
            data.put((Object)"author", (Object)webpage.getAuthor());
            data.put((Object)"body", (Object)webpage.getBody());
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            BigDecimal portletID = (BigDecimal)data.get((Object)WebpagePortletEditorPage.PORTLET_ID);
            WebpagePortlet portlet = this.getWebpagePortlet(e.getPageState(), portletID);
            PageState ps = e.getPageState();
            if (this.editSubmit1.isSelected(ps)) {
                Webpage webpage = portlet.getWebpage();
                portlet.setTitle((String)data.get((Object)"title"));
                webpage.setTitle((String)data.get((Object)"title"));
                webpage.setAuthor((String)data.get((Object)"author"));
                webpage.setBody((String)data.get((Object)"body"));
                portlet.save();
                webpage.save();
            }
            Application site = (Application)portlet.getParentResource();
            try {
                DispatcherHelper.sendRedirect((HttpServletRequest)ps.getRequest(), (HttpServletResponse)ps.getResponse(), (String)site.getPath());
            }
            catch (IOException ex) {
                throw new FormProcessException((Throwable)ex);
            }
        }

        private WebpagePortlet getWebpagePortlet(PageState ps) throws FormProcessException {
            String portletIDString = ps.getRequest().getParameter(WebpagePortletEditorPage.PORTLET_ID);
            if (portletIDString == null) {
                throw new FormProcessException("Illegal portlet ID: " + portletIDString);
            }
            BigDecimal portletID = new BigDecimal(portletIDString);
            return this.getWebpagePortlet(ps, portletID);
        }

        protected WebpagePortlet getWebpagePortlet(PageState ps, BigDecimal portletID) throws FormProcessException {
            WebpagePortlet portlet = (WebpagePortlet)Portlet.retrievePortlet((BigDecimal)portletID);
            if (portlet == null) {
                throw new FormProcessException("Illegal Webpage Portlet ID: " + portletID);
            }
            User user = Web.getContext().getUser();
            PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.EDIT, (ACSObject)portlet.getParentResource(), (Party)user);
            if (!PermissionService.checkPermission((PermissionDescriptor)perm)) {
                throw new FormProcessException("You do not have permission to edit this item.");
            }
            return portlet;
        }
    }
}

