/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.webpage.ui;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.cms.webpage.Webpage;
import com.arsdigita.cms.webpage.installer.Initializer;
import com.arsdigita.cms.webpage.tools.UrlUtil;
import com.arsdigita.cms.webpage.ui.WebpagePortlet;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;

class WebpagePortletRenderer
extends AbstractPortletRenderer {
    private WebpagePortlet m_portlet;

    public WebpagePortletRenderer(WebpagePortlet portlet) {
        this.m_portlet = portlet;
    }

    protected void generateBodyXML(PageState pageState, Element parent) {
        Webpage webpage = this.m_portlet.getWebpage();
        Label label = new Label(webpage.getBody(), false);
        label.generateXML(pageState, parent);
        PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.EDIT, (ACSObject)Web.getContext().getApplication(), (Party)Web.getContext().getUser());
        if (PermissionService.checkPermission((PermissionDescriptor)perm)) {
            StringBuffer appLinkURL = new StringBuffer(Web.getConfig().getDispatcherServletPath());
            appLinkURL.append('/');
            appLinkURL.append(Initializer.getConfig().getContentSection());
            appLinkURL.append("/edit.jsp?portletID=");
            appLinkURL.append(this.m_portlet.getID());
            Element applink = parent.newChildElement("bebop:applicationlink", "http://www.arsdigita.com/bebop/1.0");
            applink.addAttribute("value", UrlUtil.prepareURL(pageState, appLinkURL.toString(), null, false));
        }
    }
}

