/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.webpage.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.MultipleSelect;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.CMSDHTMLEditor;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.webpage.Webpage;
import com.arsdigita.cms.webpage.installer.Initializer;
import com.arsdigita.cms.webpage.ui.AuthorLabelPrinter;
import com.arsdigita.cms.webpage.ui.CategoriesPrintListener;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.ArrayList;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class WebpagePropertiesForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener {
    private static final Logger s_log = Logger.getLogger(WebpagePropertiesForm.class);
    public static final String DESCRIPTION = "description";
    public static final String BODY = "body";
    public static final String CATEGORIES = "categories";

    public WebpagePropertiesForm(ItemSelectionModel itemModel) {
        super("id", itemModel);
    }

    protected void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label((PrintListener)new AuthorLabelPrinter()));
        this.add((Component)new TextField("author"));
        this.add((Component)new Label("Categories"));
        MultipleSelect catSelect = new MultipleSelect(CATEGORIES);
        catSelect.setSize(20);
        try {
            ContentSection section = Initializer.getConfig().getWebpageSection();
            catSelect.addPrintListener((PrintListener)new CategoriesPrintListener(section));
        }
        catch (TooManyListenersException tmex) {
            throw new UncheckedWrapperException(tmex.getMessage());
        }
        this.add((Component)catSelect);
        this.add((Component)new Label("Description:"));
        StringParameter descriptionParam = new StringParameter(DESCRIPTION);
        TextArea description = new TextArea((ParameterModel)descriptionParam);
        description.setCols(80);
        description.setRows(20);
        this.add((Component)description);
        this.add((Component)new Label("Body:"));
        StringParameter bodyParam = new StringParameter(BODY);
        CMSDHTMLEditor body = new CMSDHTMLEditor((ParameterModel)bodyParam);
        body.setCols(40);
        body.setRows(5);
        this.add((Component)body);
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        super.validate(e);
    }

    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        Webpage webpage = (Webpage)super.initBasicWidgets(fse);
        data.put((Object)DESCRIPTION, (Object)webpage.getDescription());
        data.put((Object)BODY, (Object)webpage.getBody());
        data.put((Object)"author", (Object)webpage.getAuthor());
        data.put((Object)BODY, (Object)webpage.getBody());
        ArrayList<String> assignedCats = new ArrayList<String>();
        CategoryCollection cc = webpage.getCategoryCollection();
        while (cc.next()) {
            String catID = cc.getCategory().getID().toString();
            assignedCats.add(catID);
        }
        data.put((Object)CATEGORIES, (Object)assignedCats.toArray());
    }

    public void process(FormSectionEvent fse) throws FormProcessException {
        FormData data = fse.getFormData();
        Webpage webpage = (Webpage)super.processBasicWidgets(fse);
        if (webpage != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            webpage.setDescription((String)data.get((Object)DESCRIPTION));
            webpage.setBody((String)data.get((Object)BODY));
            webpage.setAuthor((String)data.get((Object)"author"));
            webpage.setCategories((String[])data.get((Object)CATEGORIES));
            webpage.save();
        }
    }
}

