/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.ui;

import com.arsdigita.categorization.Category;
import com.arsdigita.cms.scipublications.exporter.SciPublicationsExporters;
import com.arsdigita.cms.scipublications.imexporter.PublicationFormat;
import com.arsdigita.navigation.ui.AbstractComponent;
import com.arsdigita.navigation.ui.object.CustomizableObjectList;
import com.arsdigita.xml.Element;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PublicationExportLinks
extends AbstractComponent {
    private CustomizableObjectList objList;

    public Element generateXML(HttpServletRequest request, HttpServletResponse response) {
        Element parent = new Element("publicationExportLinks");
        List formats = SciPublicationsExporters.getInstance().getSupportedFormats();
        for (PublicationFormat format : formats) {
            this.createExportLink(format, parent, this.getCategory());
        }
        return parent;
    }

    public void setObjList(CustomizableObjectList objList) {
        this.objList = objList;
    }

    private void createExportLink(PublicationFormat format, Element parent, Category category) {
        Element exportLinkElem = parent.newChildElement("publicationExportLink");
        Element formatKeyElem = exportLinkElem.newChildElement("formatKey");
        formatKeyElem.setText(format.getName().toLowerCase());
        Element formatNameElem = exportLinkElem.newChildElement("formatName");
        formatNameElem.setText(format.getName());
        Element categoryIdElem = exportLinkElem.newChildElement("categoryId");
        categoryIdElem.setText(category.getID().toString());
        Element filterSqlElem = exportLinkElem.newChildElement("filterSql");
        try {
            filterSqlElem.setText(URLEncoder.encode(this.objList.getFilterSql(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            filterSqlElem.setText("");
        }
        Element desCatsElem = exportLinkElem.newChildElement("descendCategories");
        if (this.objList.getDefinition().getDescendCategories()) {
            desCatsElem.setText("true");
        } else {
            desCatsElem.setText("false");
        }
    }
}

