/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ExtraXMLGenerator;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.SciDepartmentConfig;
import com.arsdigita.cms.contenttypes.SciDepartmentMemberStatus;
import com.arsdigita.cms.contenttypes.ui.SciDepartmentExtraXmlGenerator;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.List;

public class SciDepartment
extends GenericOrganizationalUnit {
    public static final String DEPARTMENT_SHORT_DESCRIPTION = "departmentShortDescription";
    public static final String DEPARTMENT_DESCRIPTION = "departmentDescription";
    public static final String ROLE_ENUM_NAME = "SciDepartmentRole";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.SciDepartment";
    private static final SciDepartmentConfig config = new SciDepartmentConfig();

    public SciDepartment() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public SciDepartment(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public SciDepartment(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public SciDepartment(DataObject dataObject) {
        super(dataObject);
    }

    public SciDepartment(String type) {
        super(type);
    }

    public static SciDepartmentConfig getConfig() {
        return config;
    }

    public String getDepartmentShortDescription() {
        return (String)this.get(DEPARTMENT_SHORT_DESCRIPTION);
    }

    public void setDepartmentShortDescription(String shortDesc) {
        this.set(DEPARTMENT_SHORT_DESCRIPTION, shortDesc);
    }

    public String getDepartmentDescription() {
        return (String)this.get(DEPARTMENT_DESCRIPTION);
    }

    public void setDepartmentDescription(String description) {
        this.set(DEPARTMENT_DESCRIPTION, description);
    }

    public boolean hasContacts() {
        boolean result = false;
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfContactsOfSciDepartment");
        query.setParameter("project", (Object)this.getID());
        result = query.size() > 0L;
        query.close();
        return result;
    }

    public boolean hasMembers(boolean merge, SciDepartmentMemberStatus status) {
        String queryName;
        switch (status) {
            case ALL: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfMembersOfSciDepartment";
                break;
            }
            case ACTIVE: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfActiveMembersOfSciDepartment";
                break;
            }
            case ASSOCIATED: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfAssociatedMembersOfSciDepartment";
                break;
            }
            case FORMER: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfFormerMembersOfSciDepartment";
                break;
            }
            default: {
                queryName = "";
            }
        }
        DataQuery query = SessionManager.getSession().retrieveQuery(queryName);
        query.setParameter("department", (Object)this.getID());
        if (query.size() > 0L) {
            query.close();
            return true;
        }
        if (merge) {
            query.close();
            DataQuery departmentsQuery = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfSubDepartmentsOfSciDepartment");
            departmentsQuery.setParameter("department", (Object)this.getID());
            if (query.size() > 0L) {
                BigDecimal departmentId;
                boolean result = false;
                while (departmentsQuery.next() && !(result = this.hasMembers(departmentId = (BigDecimal)departmentsQuery.get("departmentId"), merge, status))) {
                }
                departmentsQuery.close();
                return result;
            }
            departmentsQuery.close();
            return false;
        }
        query.close();
        return false;
    }

    private boolean hasMembers(BigDecimal departmentId, boolean merge, SciDepartmentMemberStatus status) {
        String queryName;
        switch (status) {
            case ALL: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfMembersOfSciDepartment";
                break;
            }
            case ACTIVE: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfActiveMembersOfSciDepartment";
                break;
            }
            case ASSOCIATED: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfAssociatedMembersOfDepartment";
                break;
            }
            case FORMER: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfFormerMembersOfSciDepartment";
                break;
            }
            default: {
                queryName = "";
            }
        }
        DataQuery query = SessionManager.getSession().retrieveQuery(queryName);
        query.setParameter("department", (Object)departmentId);
        if (query.size() > 0L) {
            query.close();
            return true;
        }
        if (merge) {
            query.close();
            DataQuery subDepartmentsQuery = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfSubDepartmentsOfSciDepartment");
            subDepartmentsQuery.setParameter("department", (Object)departmentId);
            if (query.size() > 0L) {
                BigDecimal subdepartmentId;
                boolean result = false;
                while (subDepartmentsQuery.next() && !(result = this.hasMembers(subdepartmentId = (BigDecimal)subDepartmentsQuery.get("departmentId"), merge, status))) {
                }
                subDepartmentsQuery.close();
                return result;
            }
            subDepartmentsQuery.close();
            return false;
        }
        query.close();
        return false;
    }

    public List<ExtraXMLGenerator> getExtraXMLGenerators() {
        List generators = super.getExtraXMLGenerators();
        generators.add(new SciDepartmentExtraXmlGenerator());
        return generators;
    }

    public String getSearchSummary() {
        return this.getDepartmentShortDescription();
    }

    static {
        config.load();
    }
}

