/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.SciDepartment;
import com.arsdigita.cms.contenttypes.ui.GenericOrganizationalUnitPersonAddForm;
import com.arsdigita.cms.contenttypes.ui.GenericOrganizationalUnitPersonSelector;
import com.arsdigita.domain.DataObjectNotFoundException;
import org.apache.log4j.Logger;

public class SciDepartmentMemberAddForm
extends GenericOrganizationalUnitPersonAddForm {
    private final Logger logger = Logger.getLogger(SciDepartmentMemberAddForm.class);

    public SciDepartmentMemberAddForm(ItemSelectionModel itemModel, GenericOrganizationalUnitPersonSelector personSelector) {
        super(itemModel, personSelector);
    }

    protected String getPersonType() {
        String personType = SciDepartment.getConfig().getPermittedPersonType();
        try {
            ContentType.findByAssociatedObjectType((String)personType);
        }
        catch (DataObjectNotFoundException ex) {
            this.logger.error((Object)String.format("No content type for object type '%s'. Falling back to '%s'.", personType, GenericPerson.class.getName()), (Throwable)ex);
            personType = GenericPerson.class.getName();
        }
        return personType;
    }

    protected String getRoleAttributeName() {
        return "SciDepartmentRole";
    }
}

