/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.RelationAttributeCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.SciDepartment;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitTab;
import com.arsdigita.cms.contenttypes.ui.SciDepartmentMembersTabConfig;
import com.arsdigita.cms.contenttypes.ui.panels.CompareFilter;
import com.arsdigita.cms.contenttypes.ui.panels.Paginator;
import com.arsdigita.cms.contenttypes.ui.panels.TextFilter;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SciDepartmentMembersTab
implements GenericOrgaUnitTab {
    private final Logger logger = Logger.getLogger(SciDepartmentMembersTab.class);
    private static final SciDepartmentMembersTabConfig config = new SciDepartmentMembersTabConfig();
    private static final String STATUS_PARAM = "memberStatus";
    private static final String SURNAME_PARAM = "memberSurname";
    private final CompareFilter statusFilter = new CompareFilter("memberStatus", "status", false, false, false);
    private final TextFilter surnameFilter = new TextFilter("memberSurname", "surname");

    public SciDepartmentMembersTab() {
        String[] statusValues;
        for (String status : statusValues = config.getStatusValues()) {
            this.statusFilter.addOption(status, status);
        }
    }

    public boolean hasData(GenericOrganizationalUnit orgaunit, PageState state) {
        if (orgaunit.getPersons() != null && orgaunit.getPersons().size() > 0L) {
            return true;
        }
        if (config.isMergingMembers()) {
            DataCollection persons = this.getData(orgaunit, state).getMembers();
            return persons != null && persons.isEmpty();
        }
        return false;
    }

    public void generateXml(GenericOrganizationalUnit orgaunit, Element parent, PageState state) {
        MembersData membersData = this.getData(orgaunit, state);
        DataCollection persons = membersData.getMembers();
        Map<String, String> membersRoles = membersData.getMembersRoles();
        Map<String, String> membersStatus = membersData.getMembersStatus();
        HttpServletRequest request = state.getRequest();
        this.applySurnameFilter((DataQuery)persons, request);
        Element depMembersElem = parent.newChildElement("departmentMembers");
        Element filtersElem = depMembersElem.newChildElement("filters");
        this.statusFilter.generateXml(filtersElem);
        if (persons == null || persons.isEmpty()) {
            if (this.surnameFilter != null && this.surnameFilter.getFilter() != null && !this.surnameFilter.getFilter().trim().isEmpty()) {
                this.surnameFilter.generateXml(filtersElem);
            }
            depMembersElem.newChildElement("noMembers");
            return;
        }
        RelationAttributeCollection roles = new RelationAttributeCollection("SciDepartmentRole");
        roles.addLanguageFilter(GlobalizationHelper.getNegotiatedLocale().getLanguage());
        Element rolesElem = depMembersElem.newChildElement("roles");
        while (roles.next()) {
            this.generateRoleValueElem(rolesElem, roles.getKey(), roles.getName());
        }
        RelationAttributeCollection statusValues = new RelationAttributeCollection("GenericOrganizationalUnitMemberStatus");
        statusValues.addLanguageFilter(GlobalizationHelper.getNegotiatedLocale().getLanguage());
        Element statusValuesElem = depMembersElem.newChildElement("statusValues");
        while (statusValues.next()) {
            this.generateStatusValueElem(statusValuesElem, statusValues.getKey(), statusValues.getName());
        }
        Paginator paginator = new Paginator(request, (int)persons.size(), config.getPageSize());
        if (paginator.getPageCount() > config.getEnableSearchLimit() || this.surnameFilter.getFilter() != null && !this.surnameFilter.getFilter().trim().isEmpty()) {
            this.surnameFilter.generateXml(filtersElem);
        }
        paginator.applyLimits((DataQuery)persons);
        paginator.generateXml(depMembersElem);
        while (persons.next()) {
            GenericPerson person = new GenericPerson(persons.getDataObject());
            this.generateMemberXml(person, membersRoles.get(person.getContentBundle().getID().toString()), membersStatus.get(person.getContentBundle().getID().toString()), depMembersElem, state);
        }
    }

    private void generateRoleValueElem(Element parent, String key, String value) {
        Element roleValueElem = parent.newChildElement("role");
        roleValueElem.addAttribute("key", key);
        roleValueElem.setText(value);
    }

    private void generateStatusValueElem(Element parent, String key, String value) {
        Element statusValueElem = parent.newChildElement("status");
        statusValueElem.addAttribute("key", key);
        statusValueElem.setText(value);
    }

    protected MembersData getData(GenericOrganizationalUnit orgaunit, PageState state) {
        if (!(orgaunit instanceof SciDepartment)) {
            throw new IllegalArgumentException(String.format("This tab can only process instances of 'com.arsdigita.cms.contenttypes.SciDepartment'. Provided object is of type '%s'", orgaunit.getClass().getName()));
        }
        DataQuery personBundlesQuery = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfMembersOfOrgaUnits");
        ArrayList<String> orgaUnitIds = new ArrayList<String>();
        if (config.isMergingMembers()) {
            DataQuery subDepartmentsQuery = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfSubordinateOrgaUnitsRecursivlyWithAssocType");
            subDepartmentsQuery.setParameter("orgaunitId", (Object)orgaunit.getContentBundle().getID().toString());
            subDepartmentsQuery.setParameter("assocType", (Object)"DepartmentOf");
            while (subDepartmentsQuery.next()) {
                orgaUnitIds.add(subDepartmentsQuery.get("orgaunitId").toString());
            }
        } else {
            orgaUnitIds.add(orgaunit.getContentBundle().getID().toString());
        }
        personBundlesQuery.setParameter("orgaunitIds", orgaUnitIds);
        this.applyStatusFilter(personBundlesQuery, state.getRequest());
        HashMap<String, String> membersRoles = new HashMap<String, String>();
        HashMap<String, String> membersStatus = new HashMap<String, String>();
        StringBuilder filterBuilder = new StringBuilder();
        while (personBundlesQuery.next()) {
            if (filterBuilder.length() > 0) {
                filterBuilder.append(',');
            }
            String memberId = personBundlesQuery.get("memberId").toString();
            filterBuilder.append(memberId);
            membersRoles.put(memberId, (String)personBundlesQuery.get("roleName"));
            membersStatus.put(memberId, (String)personBundlesQuery.get("status"));
        }
        DataCollection membersQuery = SessionManager.getSession().retrieve("com.arsdigita.cms.contenttypes.GenericPerson");
        if (filterBuilder.length() == 0) {
            return null;
        }
        membersQuery.addFilter(String.format("parent.id in (%s)", filterBuilder.toString()));
        membersQuery.addOrder("surname");
        membersQuery.addOrder("givenname");
        return new MembersData(membersQuery, membersRoles, membersStatus);
    }

    private void applyStatusFilter(DataQuery persons, HttpServletRequest request) {
        String filter;
        String statusValue = Globalization.decodeParameter((HttpServletRequest)request, (String)STATUS_PARAM);
        if (statusValue != null && !statusValue.trim().isEmpty()) {
            this.statusFilter.setValue(statusValue);
        }
        if ((filter = this.statusFilter.getFilter()) != null && !filter.trim().isEmpty()) {
            persons.addFilter(filter);
        }
    }

    private void applySurnameFilter(DataQuery persons, HttpServletRequest request) {
        String filter;
        String surnameValue = Globalization.decodeParameter((HttpServletRequest)request, (String)SURNAME_PARAM);
        if (surnameValue != null && !surnameValue.trim().isEmpty()) {
            this.surnameFilter.setValue(surnameValue);
        }
        if ((filter = this.surnameFilter.getFilter()) != null && !filter.trim().isEmpty()) {
            persons.addFilter(filter);
        }
    }

    protected void generateMemberXml(GenericPerson member, String role, String status, Element parent, PageState state) {
        XmlGenerator generator = new XmlGenerator((ContentItem)member);
        generator.setItemElemName("member", "");
        generator.addItemAttribute("role", role);
        generator.addItemAttribute("status", status);
        generator.generateXML(state, parent, "");
    }

    static {
        config.load();
    }

    private class XmlGenerator
    extends SimpleXMLGenerator {
        private final ContentItem item;

        public XmlGenerator(ContentItem item) {
            this.item = item;
        }

        protected ContentItem getContentItem(PageState state) {
            return this.item;
        }
    }

    protected class MembersData {
        private final DataCollection members;
        private final Map<String, String> membersRoles;
        private final Map<String, String> membersStatus;

        public MembersData(DataCollection members, Map<String, String> membersRoles, Map<String, String> membersStatus) {
            this.members = members;
            this.membersRoles = membersRoles;
            this.membersStatus = membersStatus;
        }

        public DataCollection getMembers() {
            return this.members;
        }

        public Map<String, String> getMembersRoles() {
            return Collections.unmodifiableMap(this.membersRoles);
        }

        public Map<String, String> getMembersStatus() {
            return Collections.unmodifiableMap(this.membersStatus);
        }
    }
}

