/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.SciDepartment;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitTab;
import com.arsdigita.cms.contenttypes.ui.SciDepartmentProjectsTabConfig;
import com.arsdigita.cms.contenttypes.ui.panels.CompareFilter;
import com.arsdigita.cms.contenttypes.ui.panels.Paginator;
import com.arsdigita.cms.contenttypes.ui.panels.TextFilter;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.persistence.CompoundFilter;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SciDepartmentProjectsTab
implements GenericOrgaUnitTab {
    private final Logger logger = Logger.getLogger(SciDepartmentProjectsTab.class);
    private static final SciDepartmentProjectsTabConfig config = new SciDepartmentProjectsTabConfig();
    private static final String STATUS_PARAM = "projectStatus";
    private static final String TITLE_PARAM = "projectTitle";
    private final CompareFilter statusFilter = new CompareFilter("projectStatus", "projectEnd", false, false, false, true);
    private final TextFilter titleFilter = new TextFilter("projectTitle", "title");

    public SciDepartmentProjectsTab() {
        GregorianCalendar now = new GregorianCalendar();
        String today = String.format("%d-%02d-%02d", now.get(1), now.get(2) + 1, now.get(5));
        this.statusFilter.addOption("currentProjects", CompareFilter.Operators.GTEQ, today, true);
        this.statusFilter.addOption("finishedProjects", CompareFilter.Operators.LT, today, false);
    }

    public boolean hasData(GenericOrganizationalUnit orgaunit, PageState state) {
        long start = System.currentTimeMillis();
        ContentTypeCollection types = ContentType.getAllContentTypes();
        types.addFilter("associatedObjectType = 'com.arsdigita.cms.contenttypes.SciProject'");
        if (types.size() == 0L) {
            return false;
        }
        types.close();
        DataCollection data = this.getData(orgaunit);
        boolean result = data != null && !data.isEmpty();
        this.logger.debug((Object)String.format("Needed %d ms to determine if department '%s' has projects.", System.currentTimeMillis() - start, orgaunit.getName()));
        return result;
    }

    public void generateXml(GenericOrganizationalUnit orgaunit, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        DataCollection projects = this.getData(orgaunit);
        HttpServletRequest request = state.getRequest();
        Element depProjectsElem = parent.newChildElement("departmentProjects");
        Element filtersElem = depProjectsElem.newChildElement("filters");
        projects.addOrder("case when (projectBegin is null) then '0001-01-01' else projectBegin end desc");
        projects.addOrder("case when (projectEnd is null) then '0001-01-01' else projectEnd end desc");
        projects.addOrder("title asc");
        if ((Globalization.decodeParameter((HttpServletRequest)request, (String)STATUS_PARAM) == null || Globalization.decodeParameter((HttpServletRequest)request, (String)STATUS_PARAM).trim().isEmpty() || "--NONE--".equals(Globalization.decodeParameter((HttpServletRequest)request, (String)STATUS_PARAM))) && (Globalization.decodeParameter((HttpServletRequest)request, (String)TITLE_PARAM) == null || Globalization.decodeParameter((HttpServletRequest)request, (String)TITLE_PARAM).trim().isEmpty())) {
            this.statusFilter.generateXml(filtersElem);
            depProjectsElem.newChildElement("greeting");
            GregorianCalendar now = new GregorianCalendar();
            String today = String.format("%d-%02d-%02d", now.get(1), now.get(2) + 1, now.get(5));
            projects.addFilter(String.format("(projectEnd >= '%s') or (projectEnd is null)", today));
            projects.setRange(Integer.valueOf(1), Integer.valueOf(config.getGreetingSize() + 1));
            this.titleFilter.generateXml(filtersElem);
        } else {
            this.applyStatusFilter((DataQuery)projects, request);
            this.applyTitleFilter((DataQuery)projects, request);
            this.statusFilter.generateXml(filtersElem);
            if (projects.isEmpty()) {
                this.titleFilter.generateXml(filtersElem);
                depProjectsElem.newChildElement("noProjects");
                return;
            }
            Paginator paginator = new Paginator(request, (int)projects.size(), config.getPageSize());
            if (paginator.getPageCount() > config.getEnableSearchLimit() || Globalization.decodeParameter((HttpServletRequest)request, (String)TITLE_PARAM) != null || !Globalization.decodeParameter((HttpServletRequest)request, (String)TITLE_PARAM).trim().isEmpty()) {
                this.titleFilter.generateXml(filtersElem);
            }
            paginator.applyLimits((DataQuery)projects);
            paginator.generateXml(depProjectsElem);
        }
        while (projects.next()) {
            this.generateProjectXml((BigDecimal)projects.get("id"), depProjectsElem, state);
        }
        this.logger.debug((Object)String.format("Generated projects list of department '%s' in %d ms.", orgaunit.getName(), System.currentTimeMillis() - start));
    }

    protected DataCollection getData(GenericOrganizationalUnit orgaunit) {
        long start = System.currentTimeMillis();
        if (!(orgaunit instanceof SciDepartment)) {
            throw new IllegalArgumentException(String.format("This tab can only process instances of 'com.arsdigita.cms.contenttypes.SciDepartment'. Provided object is of type '%s'", orgaunit.getClass().getName()));
        }
        DataQuery projectBundlesQuery = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfProjectsOfOrgaUnit");
        ArrayList<String> orgaunitIds = new ArrayList<String>();
        if (config.isMergingProjects()) {
            DataQuery subDepartmentsQuery = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfSubordinateOrgaUnitsRecursivlyWithAssocType");
            subDepartmentsQuery.setParameter("orgaunitId", (Object)orgaunit.getContentBundle().getID().toString());
            subDepartmentsQuery.setParameter("assocType", (Object)"DepartmentOf");
            while (subDepartmentsQuery.next()) {
                orgaunitIds.add(subDepartmentsQuery.get("orgaunitId").toString());
            }
        } else {
            orgaunitIds.add(orgaunit.getContentBundle().getID().toString());
        }
        projectBundlesQuery.setParameter("orgaunitIds", orgaunitIds);
        StringBuilder filterBuilder = new StringBuilder();
        while (projectBundlesQuery.next()) {
            if (filterBuilder.length() > 0) {
                filterBuilder.append(',');
            }
            filterBuilder.append(projectBundlesQuery.get("projectId").toString());
        }
        DataCollection projectsQuery = SessionManager.getSession().retrieve("com.arsdigita.cms.contenttypes.SciProject");
        if (filterBuilder.length() == 0) {
            return null;
        }
        projectsQuery.addFilter(String.format("parent.id in (%s)", filterBuilder.toString()));
        if (Kernel.getConfig().languageIndependentItems()) {
            FilterFactory filterFactory = projectsQuery.getFilterFactory();
            CompoundFilter filter = filterFactory.or().addFilter(filterFactory.equals("language", (Object)GlobalizationHelper.getNegotiatedLocale().getLanguage())).addFilter((Filter)filterFactory.and().addFilter(filterFactory.equals("language", (Object)GlobalizationHelper.LANG_INDEPENDENT)).addFilter(filterFactory.notIn("parent", "com.arsdigita.navigation.getParentIDsOfMatchedItems").set("language", (Object)GlobalizationHelper.getNegotiatedLocale().getLanguage())));
            projectsQuery.addFilter((Filter)filter);
        } else {
            projectsQuery.addEqualsFilter("language", (Object)GlobalizationHelper.getNegotiatedLocale().getLanguage());
        }
        this.logger.debug((Object)String.format("Got projects of department '%s'in '%d ms'. MergeProjects is set to '%b'.", orgaunit.getName(), System.currentTimeMillis() - start, config.isMergingProjects()));
        return projectsQuery;
    }

    private void applyStatusFilter(DataQuery projects, HttpServletRequest request) {
        String statusValue = Globalization.decodeParameter((HttpServletRequest)request, (String)STATUS_PARAM);
        if (statusValue != null && !statusValue.trim().isEmpty()) {
            this.statusFilter.setValue(statusValue);
        }
        if (this.statusFilter.getFilter() != null && !this.statusFilter.getFilter().trim().isEmpty()) {
            projects.addFilter(this.statusFilter.getFilter());
        }
    }

    private void applyTitleFilter(DataQuery projects, HttpServletRequest request) {
        String titleValue = Globalization.decodeParameter((HttpServletRequest)request, (String)TITLE_PARAM);
        if (titleValue != null && !titleValue.trim().isEmpty()) {
            this.titleFilter.setValue(titleValue);
        }
        if (this.titleFilter.getFilter() != null && !this.titleFilter.getFilter().trim().isEmpty()) {
            projects.addFilter(this.titleFilter.getFilter());
        }
    }

    private void generateProjectXml(BigDecimal projectId, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        ContentPage project = (ContentPage)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.contenttypes.SciProject", (Object)projectId));
        this.logger.debug((Object)String.format("Got domain object for project '%s' in %d ms.", project.getName(), System.currentTimeMillis() - start));
        this.generateProjectXml(project, parent, state);
    }

    private void generateProjectXml(ContentPage project, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        XmlGenerator generator = new XmlGenerator((ContentItem)project);
        generator.setItemElemName("project", "");
        generator.setUseExtraXml(true);
        generator.setListMode(true);
        generator.generateXML(state, parent, "");
        this.logger.debug((Object)String.format("Generated XML for project '%s' in %d ms.", project.getName(), System.currentTimeMillis() - start));
    }

    static {
        config.load();
    }

    private class XmlGenerator
    extends SimpleXMLGenerator {
        private final ContentItem item;

        public XmlGenerator(ContentItem item) {
            this.item = item;
        }

        protected ContentItem getContentItem(PageState state) {
            return this.item;
        }
    }
}

