/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.SciDepartment;
import com.arsdigita.cms.contenttypes.SciDepartmentConfig;
import com.arsdigita.cms.contenttypes.ui.GenericOrganizationalUnitPropertiesStep;
import com.arsdigita.cms.contenttypes.ui.GenericOrganizationalUnitPropertyForm;
import com.arsdigita.cms.contenttypes.ui.SciDepartmentGlobalizationUtil;
import com.arsdigita.cms.contenttypes.ui.SciDepartmentPropertiesStep;
import com.arsdigita.globalization.GlobalizedMessage;

public class SciDepartmentPropertyForm
extends GenericOrganizationalUnitPropertyForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    public static final String ID = "SciDepartmentEdit";
    private static final SciDepartmentConfig config = SciDepartment.getConfig();

    public SciDepartmentPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public SciDepartmentPropertyForm(ItemSelectionModel itemModel, SciDepartmentPropertiesStep step) {
        super(itemModel, (GenericOrganizationalUnitPropertiesStep)step);
        this.addSubmissionListener(this);
    }

    public void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label(SciDepartmentGlobalizationUtil.globalize("scidepartment.ui.shortdesc")));
        StringParameter shortDescParam = new StringParameter("departmentShortDescription");
        TextArea shortDesc = new TextArea((ParameterModel)shortDescParam);
        shortDesc.addValidationListener((ParameterListener)new StringInRangeValidationListener(0, config.getShortDescMaxLength().intValue()));
        shortDesc.setCols(75);
        shortDesc.setRows(5);
        this.add((Component)shortDesc);
    }

    public void init(FormSectionEvent fse) throws FormProcessException {
        super.init(fse);
        FormData data = fse.getFormData();
        SciDepartment department = (SciDepartment)super.initBasicWidgets(fse);
        data.put((Object)"departmentShortDescription", (Object)department.getDepartmentShortDescription());
    }

    public void process(FormSectionEvent fse) throws FormProcessException {
        super.process(fse);
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        SciDepartment department = (SciDepartment)super.processBasicWidgets(fse);
        if (department != null && this.getSaveCancelSection().getSaveButton().isSelected(state)) {
            department.setDepartmentShortDescription((String)data.get((Object)"departmentShortDescription"));
            department.save();
        }
        this.init(fse);
    }

    public GlobalizedMessage getTitleLabel() {
        return SciDepartmentGlobalizationUtil.globalize("scidepartment.ui.title");
    }
}

