/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.RelationAttributeCollection;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitContactCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitPersonCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitSubordinateCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.SciDepartment;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitTab;
import com.arsdigita.cms.contenttypes.ui.SciDepartmentSummaryTabConfig;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class SciDepartmentSummaryTab
implements GenericOrgaUnitTab {
    private final Logger logger = Logger.getLogger(SciDepartmentSummaryTab.class);
    private static final SciDepartmentSummaryTabConfig config = new SciDepartmentSummaryTabConfig();

    public boolean hasData(GenericOrganizationalUnit orgaunit, PageState state) {
        return true;
    }

    public void generateXml(GenericOrganizationalUnit orgaunit, Element parent, PageState state) {
        if (!(orgaunit instanceof SciDepartment)) {
            throw new IllegalArgumentException(String.format("This tab can only process instances of SciDpartment.The provided object is of type '%s',", orgaunit.getClass().getName()));
        }
        long start = System.currentTimeMillis();
        SciDepartment department = (SciDepartment)orgaunit;
        Element departmentSummaryElem = parent.newChildElement("departmentSummary");
        this.generateShortDescXml(department, departmentSummaryElem);
        if (config.isShowingHead()) {
            this.generateHeadOfDepartmentXml(department, departmentSummaryElem, state);
        }
        if (config.isShowingSubDepartment()) {
            this.generateSubDepartmentsXml(department, departmentSummaryElem, state);
        }
        if (config.isShowingContacts()) {
            this.generateContactsXml(department, departmentSummaryElem, state);
        }
        this.logger.debug((Object)String.format("Generated XML for summary tab of department '%s' in %d ms.", orgaunit.getName(), System.currentTimeMillis() - start));
    }

    protected void generateShortDescXml(SciDepartment department, Element parent) {
        long start = System.currentTimeMillis();
        if (department != null && department.getDepartmentShortDescription() != null && !department.getDepartmentShortDescription().trim().isEmpty()) {
            Element shortDescElem = parent.newChildElement("shortDesc");
            shortDescElem.setText(department.getDepartmentShortDescription());
        }
        this.logger.debug((Object)String.format("Generated short desc XML for department '%s' in %d ms", department.getName(), System.currentTimeMillis() - start));
    }

    protected void generateHeadOfDepartmentXml(SciDepartment department, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        String headRoleStr = config.getHeadRole();
        String activeStatusStr = config.getActiveStatus();
        String[] headRoles = headRoleStr.split(",");
        String[] activeStatuses = activeStatusStr.split(",");
        StringBuffer roleFilter = new StringBuffer();
        for (String headRole : headRoles) {
            if (roleFilter.length() > 0) {
                roleFilter.append(',');
            }
            roleFilter.append(String.format("%s = '%s'", "link.role_name", headRole));
        }
        StringBuffer statusFilter = new StringBuffer();
        for (String activeStatus : activeStatuses) {
            if (statusFilter.length() > 0) {
                statusFilter.append(",");
            }
            statusFilter.append(String.format("%s = '%s'", "link.status", activeStatus));
        }
        Element headsElem = parent.newChildElement("heads");
        GenericOrganizationalUnitPersonCollection heads = department.getPersons();
        heads.addFilter(roleFilter.toString());
        heads.addFilter(statusFilter.toString());
        heads.addOrder("name");
        while (heads.next()) {
            this.generateHeadXml(heads.getPerson(), headsElem, state);
        }
        this.logger.debug((Object)String.format("Generated head of department XML for department '%s' in %d ms", department.getName(), System.currentTimeMillis() - start));
    }

    protected void generateSubDepartmentsXml(SciDepartment department, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        GenericOrganizationalUnitSubordinateCollection subDepartments = department.getSubordinateOrgaUnits();
        subDepartments.addFilter(String.format("%s = '%s'", "link.assocType", "DepartmentOf"));
        Element subDepsElem = parent.newChildElement("subDepartments");
        while (subDepartments.next()) {
            this.generateSubDepartmentXml(subDepartments.getGenericOrganizationalUnit(), subDepsElem, state);
        }
        this.logger.debug((Object)String.format("Generated sub departments XML for department '%s' in %d ms", department.getName(), System.currentTimeMillis() - start));
    }

    protected void generateSubDepartmentXml(GenericOrganizationalUnit orgaunit, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        if (!(orgaunit instanceof SciDepartment)) {
            throw new IllegalArgumentException(String.format("Can't process orgaunit '%s' as sub department because the orgaunit is not a SciDepartment but of type '%s'.", orgaunit.getName(), orgaunit.getClass().getName()));
        }
        SciDepartment subDepartment = (SciDepartment)orgaunit;
        Element subDepElem = parent.newChildElement("subDepartment");
        subDepElem.addAttribute("oid", subDepartment.getOID().toString());
        Element nameElem = subDepElem.newChildElement("title");
        nameElem.setText(subDepartment.getTitle());
        this.generateHeadOfDepartmentXml(subDepartment, subDepElem, state);
        this.logger.debug((Object)String.format("Generated XML for sub department '%s' in %d ms", orgaunit.getName(), System.currentTimeMillis() - start));
    }

    protected void generateHeadXml(BigDecimal memberId, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        GenericPerson member = new GenericPerson(memberId);
        this.logger.debug((Object)String.format("Got domain object for member '%s' in %d ms.", member.getFullName(), System.currentTimeMillis() - start));
        this.generateHeadXml(member, parent, state);
    }

    protected void generateHeadXml(GenericPerson member, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        XmlGenerator generator = new XmlGenerator((ContentItem)member);
        generator.setUseExtraXml(false);
        generator.setItemElemName("head", "");
        generator.generateXML(state, parent, "");
        this.logger.debug((Object)String.format("Generated XML for member '%s' in %d ms.", member.getFullName(), System.currentTimeMillis() - start));
    }

    protected void generateContactsXml(SciDepartment department, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        GenericOrganizationalUnitContactCollection contacts = department.getContacts();
        if (contacts == null || contacts.isEmpty()) {
            return;
        }
        Element contactsElem = parent.newChildElement("contacts");
        while (contacts.next()) {
            this.generateContactXml(contacts.getContact(), contacts.getContactType(), contactsElem, state);
        }
        this.logger.debug((Object)String.format("Generated XML for contacts of project '%s' in %d ms.", department.getName(), System.currentTimeMillis() - start));
    }

    protected void generateContactXml(GenericContact contact, String contactType, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        XmlGenerator generator = new XmlGenerator((ContentItem)contact);
        generator.setUseExtraXml(false);
        generator.setItemElemName("contact", "");
        generator.addItemAttribute("contactType", this.getContactTypeName(contactType));
        generator.generateXML(state, parent, "");
        this.logger.debug((Object)String.format("Generated XML for contact '%s' in %d ms.", contact.getName(), System.currentTimeMillis() - start));
    }

    private String getContactTypeName(String contactTypeKey) {
        RelationAttributeCollection relAttrs = new RelationAttributeCollection();
        relAttrs.addFilter(String.format("attribute = '%s'", "GenericContactTypes"));
        relAttrs.addFilter(String.format("attr_key = '%s'", contactTypeKey));
        relAttrs.addFilter(String.format("lang = '%s'", GlobalizationHelper.getNegotiatedLocale().getLanguage()));
        if (relAttrs.isEmpty()) {
            return contactTypeKey;
        }
        relAttrs.next();
        String result = relAttrs.getName();
        relAttrs.close();
        return result;
    }

    static {
        config.load();
    }

    private class XmlGenerator
    extends SimpleXMLGenerator {
        private final ContentItem item;

        public XmlGenerator(ContentItem item) {
            this.item = item;
        }

        protected ContentItem getContentItem(PageState state) {
            return this.item;
        }
    }
}

