/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.FileUpload;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Organization;
import com.arsdigita.cms.contenttypes.ui.OrganizationImageStep;
import com.arsdigita.cms.contenttypes.util.OrganizationGlobalizationUtil;
import com.arsdigita.cms.ui.ImageDisplay;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class OrganizationImageForm
extends Form
implements FormInitListener,
FormProcessListener,
FormValidationListener,
FormSubmissionListener {
    private OrganizationImageStep m_step;
    private static final Logger s_log = Logger.getLogger(OrganizationImageForm.class);
    public static final String IMAGE = "image";
    public static final String ID = "Organization_image";
    public static final String IMAGE_OPTIONS = "_imageOptions";
    public static final String UPLOAD_OPTION = "upload";
    public static final String DELETE_OPTION = "delete";
    public static final String IGNORE_OPTION = "ignore";
    public ImageDisplay m_imageDisplay;
    public Label m_currentLabel;
    public Label m_label;
    public FileUpload m_upload;
    public Label m_radioLabel;
    public RadioGroup m_group;
    private ItemSelectionModel m_itemModel;
    private SaveCancelSection m_saveCancelSection;

    public OrganizationImageForm(ItemSelectionModel itemModel) {
        this("OrganizationImageForm", itemModel);
    }

    public OrganizationImageForm(String name, ItemSelectionModel itemModel) {
        this("OrganizationImageForm", itemModel, null);
    }

    public OrganizationImageForm(String name, ItemSelectionModel itemModel, OrganizationImageStep step) {
        super(name);
        this.m_itemModel = itemModel;
        this.m_step = step;
        this.setMethod("post");
        this.setEncType("multipart/form-data");
        FormErrorDisplay errorDisplay = new FormErrorDisplay((Form)this);
        errorDisplay.setStateParamsAreRegistered(false);
        this.add((Component)errorDisplay, 65);
        this.m_imageDisplay = new ImageDisplay(itemModel){

            protected ImageAsset getImageAsset(PageState state) {
                ImageAsset image = ((Organization)this.getImageSelectionModel().getSelectedObject(state)).getImage();
                return image;
            }
        };
        StringParameter imageOptions = new StringParameter("image_imageOptions");
        this.m_group = new RadioGroup((ParameterModel)imageOptions);
        this.m_group.addOption(new Option(UPLOAD_OPTION, (Component)new Label(OrganizationGlobalizationUtil.globalize("cms.contenttypes.ui.organization.file_upload"))));
        this.m_group.addOption(new Option(DELETE_OPTION, (Component)new Label(OrganizationGlobalizationUtil.globalize("cms.contenttypes.ui.organization.file_delete"))));
        this.m_group.addOption(new Option(IGNORE_OPTION, (Component)new Label(OrganizationGlobalizationUtil.globalize("cms.contenttypes.ui.organization.file_ignore"))));
        this.m_group.setDefaultValue((Object)IGNORE_OPTION);
        this.m_currentLabel = new Label(OrganizationGlobalizationUtil.globalize("cms.contenttypes.ui.organization.current_image"));
        this.add((Component)this.m_currentLabel);
        this.add((Component)this.m_imageDisplay);
        this.m_label = new Label(OrganizationGlobalizationUtil.globalize("cms.contenttypes.ui.organization.image"));
        this.add((Component)this.m_label);
        this.m_upload = new FileUpload(IMAGE);
        this.add((Component)this.m_upload);
        this.m_radioLabel = new Label("");
        this.add((Component)this.m_radioLabel);
        this.add((Component)this.m_group);
        this.m_saveCancelSection = new SaveCancelSection();
        this.add((Component)this.m_saveCancelSection);
        this.addInitListener(this);
        this.addProcessListener(this);
        this.addValidationListener(this);
        this.addSubmissionListener(this);
    }

    private ItemSelectionModel getItemSelectionModel() {
        return this.m_itemModel;
    }

    public void init(FormSectionEvent fse) {
        PageState state = fse.getPageState();
        Organization item = (Organization)this.getItemSelectionModel().getSelectedObject(state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(FormSectionEvent fse) throws FormProcessException {
        PageState state = fse.getPageState();
        FormData data = fse.getFormData();
        Organization item = (Organization)this.getItemSelectionModel().getSelectedObject(state);
        ImageAsset image = null;
        String imageOption = (String)data.get((Object)"image_imageOptions");
        if (imageOption != null && imageOption.equals(UPLOAD_OPTION)) {
            s_log.debug((Object)"uploading image");
            String fileName = (String)data.get((Object)IMAGE);
            if (fileName == null || fileName.length() <= 0) throw new FormProcessException((String)OrganizationGlobalizationUtil.globalize("cms.contenttypes.ui.organization.image_option_null").localize());
            File file = ((MultipartHttpServletRequest)state.getRequest()).getFile(IMAGE);
            s_log.debug((Object)("file: " + file));
            ImageAsset a = new ImageAsset();
            a.setName(fileName);
            try {
                s_log.debug((Object)("fileName: " + fileName));
                a.loadFromFile(fileName, file, "image/jpeg");
                s_log.debug((Object)"saving");
                a.save();
                image = a;
            }
            catch (IOException ex) {
                throw new FormProcessException((Throwable)ex);
            }
        } else if (imageOption != null && imageOption.equals(DELETE_OPTION)) {
            s_log.debug((Object)"deleting image step");
            image = null;
        } else {
            s_log.debug((Object)"ignoring image step");
            image = item.getImage();
        }
        item.setImage(image);
        item.save();
        if (this.m_step == null) return;
        this.m_step.maybeForwardToNextStep(fse.getPageState());
    }

    public void validate(FormSectionEvent fse) throws FormProcessException {
        FormData data = fse.getFormData();
        String imageOption = (String)data.get((Object)"image_imageOptions");
        String fileName = (String)fse.getFormData().get((Object)IMAGE);
        s_log.debug((Object)("validate option: " + imageOption));
        s_log.debug((Object)("validate filename: " + fileName));
        if (imageOption == null || imageOption.equals(IGNORE_OPTION)) {
            if (fileName != null && !fileName.equals("")) {
                data.addError(IMAGE, OrganizationGlobalizationUtil.globalize("cms.contenttypes.ui.organization.chose_image_when_ignoring"));
            }
        } else if (imageOption.equals(DELETE_OPTION)) {
            if (fileName != null && !fileName.equals("")) {
                data.addError(IMAGE, OrganizationGlobalizationUtil.globalize("cms.contenttypes.ui.organization.chose_image_when_deleting"));
            }
        } else if (fileName == null || fileName.equals("")) {
            data.addError(IMAGE, OrganizationGlobalizationUtil.globalize("cms.contenttypes.ui.organization.chose_image_when_uploading"));
        }
    }

    public void submitted(FormSectionEvent fse) throws FormProcessException {
        if (this.m_step != null && this.m_saveCancelSection.getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }
}

