/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.Service;
import com.arsdigita.cms.contenttypes.ui.OrganizationImageForm;
import com.arsdigita.cms.contenttypes.util.OrganizationGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import java.math.BigDecimal;

public class OrganizationImageStep
extends SimpleEditStep {
    public static String IMAGE_SHEET_NAME = "image";

    public OrganizationImageStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent, "_image");
        this.setDefaultEditKey(IMAGE_SHEET_NAME);
        this.add(IMAGE_SHEET_NAME, GlobalizationUtil.globalize((String)"cms.ui.edit"), (ComponentAccess)new WorkflowLockedComponentAccess((Component)new OrganizationImageForm("OrganizationImageForm", itemModel, this), itemModel));
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel, false);
        sheet.add(OrganizationGlobalizationUtil.globalize("cms.contenttypes.ui.organization.image"), "image", (DomainObjectPropertySheet.AttributeFormatter)new ImageFormatter());
        this.setDisplayComponent((Component)sheet);
    }

    public static class ImageFormatter
    implements DomainObjectPropertySheet.AttributeFormatter {
        private String m_default;

        public ImageFormatter() {
            this("no image");
        }

        public ImageFormatter(String def) {
            this.m_default = def;
        }

        public String getDefaultString() {
            return this.m_default;
        }

        public String format(DomainObject obj, String attribute, PageState state) {
            DataObject imageDO = (DataObject)((ContentItem)obj).get(attribute);
            if (imageDO == null) {
                return this.getDefaultString();
            }
            ImageAsset image = new ImageAsset(imageDO);
            return ImageFormatter.getHTMLDisplay(image);
        }

        public static String getHTMLDisplay(ImageAsset image) {
            if (image == null) {
                return "no image";
            }
            BigDecimal width = image.getWidth();
            String widthStr = "";
            if (width != null) {
                widthStr = " width=\"" + width.toString() + "\" ";
            }
            BigDecimal height = image.getHeight();
            String heightStr = "";
            if (height != null) {
                heightStr = " height=\"" + height.toString() + "\" ";
            }
            String labelStr = "<img src=\"" + Service.getImageURL((ImageAsset)image) + "\" " + widthStr + heightStr + "/>";
            return labelStr;
        }
    }
}

