/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Organization;
import com.arsdigita.cms.contenttypes.util.OrganizationGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.cms.ui.authoring.PageCreate;
import com.arsdigita.kernel.ACSObject;

public class OrganizationCreate
extends PageCreate {
    public static final String LINK = "link";
    public static final String CONTACT = "contact";
    private CreationSelector m_parent;

    public OrganizationCreate(ItemSelectionModel itemModel, CreationSelector parent) {
        super(itemModel, parent);
        this.m_parent = parent;
    }

    protected void addWidgets() {
        super.addWidgets();
        TextField link = new TextField(LINK);
        this.add((Component)new Label(OrganizationGlobalizationUtil.globalize("cms.contenttypes.ui.organization.link")));
        this.add((Component)link);
        TextField contact = new TextField(CONTACT);
        this.add((Component)new Label(OrganizationGlobalizationUtil.globalize("cms.contenttypes.ui.organization.contact")));
        this.add((Component)contact);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        ItemSelectionModel m = this.getItemSelectionModel();
        Folder f = this.m_parent.getFolder(state);
        ContentSection sec = this.m_parent.getContentSection(state);
        Organization org = (Organization)this.createContentPage(state);
        org.setLanguage((String)data.get((Object)"language"));
        org.setName((String)data.get((Object)"name"));
        org.setTitle((String)data.get((Object)"title"));
        org.setLink((String)data.get((Object)LINK));
        org.setContact((String)data.get((Object)CONTACT));
        org.save();
        ContentBundle bundle = new ContentBundle((ContentItem)org);
        bundle.setParent((ACSObject)f);
        bundle.setContentSection(this.m_parent.getContentSection(state));
        bundle.save();
        this.getWorkflowSection().applyWorkflow(state, (ContentItem)org);
        this.m_parent.editItem(state, (ContentItem)org);
    }
}

