/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.aplaws;

import com.arsdigita.aplaws.Aplaws;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.london.cms.dublin.DublinCoreItem;
import com.arsdigita.london.terms.Domain;
import com.arsdigita.london.terms.Term;
import com.arsdigita.london.terms.ui.ItemCategoryPicker;
import com.arsdigita.london.util.Transaction;
import com.arsdigita.navigation.Navigation;
import com.arsdigita.navigation.NavigationFileResolver;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.search.ContentProvider;
import com.arsdigita.search.ContentType;
import com.arsdigita.search.MetadataProvider;
import com.arsdigita.search.MetadataProviderRegistry;
import com.arsdigita.util.cmd.Program;
import com.arsdigita.web.Application;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.Constants;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AutoCategorisation
extends Program {
    private static final Logger LOG = Logger.getLogger(AutoCategorisation.class);
    private static final String CCM_PREFIX = "/ccm/";
    private SAXParser parser;

    public AutoCategorisation() {
        super("AutoCategorisation", "1.0", "FILENAME(Searchlight XML report)");
        Options options = this.getOptions();
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"test");
        OptionBuilder.withDescription((String)"Test only");
        options.addOption(OptionBuilder.create((char)'t'));
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("SAX parser configuration error", pce);
        }
        catch (SAXException se) {
            throw new RuntimeException("SAX parser error", se);
        }
    }

    protected void doRun(final CommandLine cmdLine) {
        new Transaction(){

            public void doRun() {
                new KernelExcursion(){

                    public void excurse() {
                        this.setEffectiveParty(Kernel.getSystemParty());
                        String[] args = cmdLine.getArgs();
                        if (args.length == 1) {
                            String filename = args[0];
                            try {
                                boolean persistChanges = !cmdLine.hasOption('t');
                                AutoCategorisation.this.parser.parse(new InputSource(new FileReader(filename)), (DefaultHandler)new SearchlightHandler(AutoCategorisation.this.isDebug(), AutoCategorisation.this.isVerbose(), persistChanges));
                            }
                            catch (SAXException ex) {
                                throw new RuntimeException(ex);
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                        } else {
                            AutoCategorisation.this.help(System.err);
                            System.exit(1);
                        }
                    }
                }.run();
            }
        }.run();
    }

    public static void main(String[] args) {
        new AutoCategorisation().run(args);
    }

    private static void out(String line) {
        LOG.info((Object)line);
    }

    private static Term findTerm(String domainKey, String name) {
        try {
            Domain domain = Domain.retrieve((String)domainKey);
            if (domain != null) {
                DomainCollection terms = domain.getTerms();
                Filter f = terms.addFilter("upper(model.name) = :name");
                f.set("name", (Object)name.toUpperCase());
                if (terms.next()) {
                    Term term = (Term)terms.getDomainObject();
                    terms.close();
                    return term;
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static Collection getAutoTerms(ContentItem item) throws ServiceFailed {
        HashSet terms = new HashSet();
        try {
            MetadataProvider adapter = MetadataProviderRegistry.findAdapter((ObjectType)item.getObjectType());
            if (adapter != null) {
                ContentProvider[] content = adapter.getContent((DomainObject)item, ContentType.TEXT);
                StringBuffer buf = new StringBuffer();
                int n = content.length;
                for (int i = 0; i < n; ++i) {
                    if (!content[i].getType().equals(ContentType.TEXT)) continue;
                    buf.append(new String(content[i].getBytes()));
                }
                String endpoint = Aplaws.getAplawsConfig().getAutocatServiceURL();
                String version = "1.0";
                Service service = new Service();
                Call call = (Call)service.createCall();
                call.setTargetEndpointAddress(new URL(endpoint));
                call.setOperationName("getCategoriesAndKeywordsFromText");
                call.addParameter("text", Constants.XSD_STRING, ParameterMode.IN);
                call.addParameter("version", Constants.XSD_STRING, ParameterMode.IN);
                call.setUsername(Aplaws.getAplawsConfig().getAutocatServiceUsername());
                call.setPassword(Aplaws.getAplawsConfig().getAutocatServicePassword());
                call.setReturnType(Constants.XSD_STRING);
                LOG.debug((Object)("username/password=" + call.getUsername() + "/" + call.getPassword()));
                String result = (String)call.invoke(new Object[]{buf.toString(), version});
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(new InputSource(new StringReader(result)), (DefaultHandler)new SearchlightServiceHandler(terms));
            } else {
                LOG.info((Object)("no metadata adapter for " + item));
            }
        }
        catch (Exception e) {
            LOG.info((Object)"autocat service call failed", (Throwable)e);
            throw new ServiceFailed(e);
        }
        return terms;
    }

    public static class ServiceFailed
    extends RuntimeException {
        public ServiceFailed(Throwable cause) {
            super(cause);
        }
    }

    private static class SearchlightServiceHandler
    extends DefaultHandler {
        StringBuffer buffer;
        String category = null;
        String thesaurus = null;
        String score = null;
        Collection terms;

        public SearchlightServiceHandler(Collection terms) {
            this.terms = terms;
        }

        @Override
        public void characters(char[] ch, int start, int len) throws SAXException {
            for (int i = 0; i < len; ++i) {
                this.buffer.append(ch[start + i]);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.buffer = new StringBuffer();
            if ("searchlight:category-match".equals(qName)) {
                this.score = attributes.getValue("score");
            } else if (this.category != null && this.score != null && "searchlight:thesaurus-ref".equals(qName)) {
                this.thesaurus = attributes.getValue("thesaurus");
                if ("IPSV".equals(this.thesaurus)) {
                    LOG.debug((Object)("IPSV " + this.category));
                    Term t = AutoCategorisation.findTerm(this.thesaurus, this.category);
                    if (t != null) {
                        this.terms.add(t);
                        LOG.debug((Object)("term = " + t));
                    } else {
                        LOG.debug((Object)"term not found");
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("searchlight:category".equals(qName)) {
                this.category = this.buffer.toString();
            } else if ("searchlight:category-match".equals(qName)) {
                this.category = null;
                this.score = null;
                this.thesaurus = null;
            } else if ("searchlight:category-matches".equals(qName)) {
                LOG.debug((Object)("terms autodetected " + this.terms));
            }
        }
    }

    private static class SearchlightHandler
    extends DefaultHandler {
        boolean isDebug;
        boolean isVerbose;
        boolean persistChanges;
        StringBuffer buffer;
        String urlid;
        String url;
        ContentItem item;
        String scheme;
        Collection keywords = new HashSet();
        Collection terms = new HashSet();
        Domain ipsv;
        Domain lgcl;
        Domain gcl;
        Domain lgsl;
        Domain lgdl;

        public SearchlightHandler(boolean isDebug, boolean isVerbose, boolean persistChanges) {
            this.isDebug = isDebug;
            this.isVerbose = isVerbose;
            this.persistChanges = persistChanges;
            this.ipsv = Domain.retrieve((String)"IPSV");
            this.lgcl = Domain.retrieve((String)"LGCL");
            this.gcl = Domain.retrieve((String)"GCL");
            this.lgsl = Domain.retrieve((String)"LGSL");
            this.lgdl = Domain.retrieve((String)"LGDL");
        }

        @Override
        public void startDocument() throws SAXException {
            if (this.isDebug) {
                AutoCategorisation.out("startDoc");
            }
        }

        @Override
        public void characters(char[] ch, int start, int len) throws SAXException {
            for (int i = 0; i < len; ++i) {
                this.buffer.append(ch[start + i]);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.isDebug) {
                AutoCategorisation.out("startElement " + qName);
            }
            this.buffer = new StringBuffer();
            if ("url".equals(qName)) {
                this.urlid = null;
                this.url = null;
                this.item = null;
            } else if ("unformated_data".equals(qName)) {
                this.keywords.clear();
                this.terms.clear();
                this.scheme = null;
            } else if ("keyword_data".equals(qName)) {
                this.scheme = attributes.getValue("scheme");
            } else if ("category_data".equals(qName)) {
                this.scheme = attributes.getValue("scheme");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.isDebug) {
                AutoCategorisation.out("endElement " + qName);
            }
            if ("urlid".equals(qName)) {
                this.urlid = this.buffer.toString();
                if (this.isVerbose) {
                    AutoCategorisation.out("urlid " + this.urlid);
                }
            } else if ("urladdress".equals(qName)) {
                this.findItem();
                if (this.item != null && this.isVerbose) {
                    AutoCategorisation.out("item " + this.item + " at " + this.url);
                }
            } else if ("keyword_data".equals(qName)) {
                StringTokenizer tok = new StringTokenizer(this.buffer.toString(), ";");
                while (tok.hasMoreTokens()) {
                    this.keywords.add(tok.nextToken().trim());
                }
            } else if ("category_data".equals(qName)) {
                if ("IPSV".equals(this.scheme)) {
                    StringTokenizer tok = new StringTokenizer(this.buffer.toString(), ";");
                    while (tok.hasMoreTokens()) {
                        String name = tok.nextToken().trim();
                        Term term = AutoCategorisation.findTerm(this.scheme, name);
                        if (term != null) {
                            this.terms.add(term);
                            continue;
                        }
                        if (!this.isVerbose) continue;
                        AutoCategorisation.out("term not found " + this.scheme + '/' + name);
                    }
                }
            } else if ("unformated_data".equals(qName)) {
                this.assignKeywords();
                this.assignTerms();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.isDebug) {
                AutoCategorisation.out("endDoc");
            }
        }

        private void findItem() {
            this.url = this.buffer.toString();
            int ccmPrefix = this.url.indexOf(AutoCategorisation.CCM_PREFIX);
            if (ccmPrefix > -1) {
                int appBegin = ccmPrefix + 5;
                int appEnd = this.url.indexOf(47, appBegin);
                if (appEnd > appBegin) {
                    String appURL = this.url.substring(appBegin, appEnd);
                    Application app = Application.retrieveApplicationForPath((String)('/' + appURL + '/'));
                    if (app != null) {
                        String appType = app.getApplicationType().getApplicationObjectType();
                        if ("com.arsdigita.cms.ContentSection".equals(appType)) {
                            ContentSection cs = (ContentSection)app;
                            ItemResolver resolver = cs.getItemResolver();
                            if (resolver != null) {
                                int queryBegin = this.url.indexOf(63, appEnd);
                                if (queryBegin > appEnd) {
                                    this.url = this.url.substring(0, queryBegin);
                                }
                                this.item = resolver.getItem(cs, this.url.substring(appEnd), "live");
                                if (this.item != null) {
                                    this.item = this.item.getDraftVersion();
                                }
                                if (this.item != null && this.item instanceof Folder) {
                                    this.item = ((Folder)this.item).getIndexItem();
                                }
                                if (this.item != null && this.item instanceof ContentBundle) {
                                    this.item = ((ContentBundle)this.item).getPrimaryInstance();
                                }
                                if (this.item == null) {
                                    AutoCategorisation.out("item not found for " + this.url);
                                }
                            } else if (this.isVerbose) {
                                AutoCategorisation.out("ContentSection without resolver");
                            }
                        } else if ("com.arsdigita.navigation.Navigation".equals(appType)) {
                            ContentBundle bundle;
                            Navigation nav = (Navigation)app;
                            Category cat = null;
                            int catBegin = this.url.indexOf("categoryID=", appEnd);
                            if (catBegin > appEnd) {
                                BigDecimal catID = new BigDecimal(this.url.substring(catBegin + 11));
                                cat = new Category(catID);
                            } else {
                                Category root = Category.getRootForObject((ACSObject)nav, null);
                                Category[] cats = NavigationFileResolver.resolveCategory((Category)root, (String)this.url.substring(appEnd));
                                if (cats != null && cats.length != 0) {
                                    cat = cats[cats.length - 1];
                                } else if (this.isVerbose) {
                                    AutoCategorisation.out("category path not found " + this.url);
                                }
                            }
                            if (cat != null && (bundle = (ContentBundle)cat.getIndexObject()) != null) {
                                this.item = bundle.getPrimaryInstance();
                            }
                        } else if (this.isVerbose) {
                            AutoCategorisation.out("unsupported application " + appType + " at " + this.url);
                        }
                    } else if (this.isVerbose) {
                        AutoCategorisation.out("application not found " + this.url);
                    }
                } else if (this.isVerbose) {
                    AutoCategorisation.out("unsupported CCM url " + this.url);
                }
            } else if (this.isVerbose) {
                AutoCategorisation.out("unsupported url " + this.url);
            }
        }

        private void assignTerms() {
            if (this.item != null) {
                ContentBundle bundle = (ContentBundle)this.item.getParent();
                HashSet<Object> manualCategories = new HashSet<Object>();
                HashSet<Object> oldAutoCategories = new HashSet<Object>();
                LinkedList<BigDecimal> newAutoCategories = new LinkedList<BigDecimal>();
                DataAssociationCursor cursor = ((DataAssociation)DomainServiceInterfaceExposer.get((DomainObject)bundle, (String)"categories")).cursor();
                while (cursor.next()) {
                    Object categoryID = cursor.get("id");
                    Boolean isAuto = (Boolean)cursor.getLinkProperty("isAuto");
                    if (isAuto.booleanValue()) {
                        oldAutoCategories.add(categoryID);
                        continue;
                    }
                    manualCategories.add(categoryID);
                }
                LinkedList<Object> manualIPSV = new LinkedList<Object>();
                LinkedList<Object> manualLGCL = new LinkedList<Object>();
                if (!manualCategories.isEmpty()) {
                    DataCollection dc = SessionManager.getSession().retrieve("com.arsdigita.london.terms.Term");
                    Filter f = dc.addFilter("model.id IN :manualCats");
                    f.set("manualCats", manualCategories);
                    dc.addFilter("domain.key IN ('IPSV','LGCL')");
                    dc.addPath("domain.key");
                    dc.addPath("model.id");
                    while (dc.next()) {
                        String domainKey = (String)dc.get("domain.key");
                        if ("IPSV".equals(domainKey)) {
                            manualIPSV.add(dc.get("model.id"));
                            continue;
                        }
                        if (!"LGCL".equals(domainKey)) continue;
                        manualLGCL.add(dc.get("model.id"));
                    }
                }
                boolean canAutoIPSV = true;
                boolean canAutoLGCL = true;
                if (manualLGCL.isEmpty() && !manualIPSV.isEmpty()) {
                    Collection relatedLGCL;
                    if (this.isVerbose) {
                        AutoCategorisation.out("derive from manual IPSV");
                    }
                    if (!(relatedLGCL = ItemCategoryPicker.getRelatedTerms(manualIPSV, (Domain)this.lgcl)).isEmpty()) {
                        ItemCategoryPicker.assignTerms((Collection)relatedLGCL, (ACSObject)bundle);
                        canAutoLGCL = false;
                    }
                }
                if (manualIPSV.isEmpty() && !manualLGCL.isEmpty()) {
                    Collection relatedIPSV;
                    if (this.isVerbose) {
                        AutoCategorisation.out("derive from manual LGCL");
                    }
                    if (!(relatedIPSV = ItemCategoryPicker.getRelatedTerms(manualLGCL, (Domain)this.ipsv)).isEmpty()) {
                        ItemCategoryPicker.assignTerms((Collection)relatedIPSV, (ACSObject)bundle);
                        canAutoIPSV = false;
                    }
                }
                for (Term t : this.terms) {
                    Domain d = t.getDomain();
                    if ((!canAutoIPSV || !this.ipsv.equals((Object)d)) && (!canAutoLGCL || !this.lgcl.equals((Object)d))) continue;
                    BigDecimal categoryID = t.getModel().getID();
                    if (!manualCategories.contains(categoryID)) {
                        if (!oldAutoCategories.contains(categoryID)) {
                            if (this.persistChanges) {
                                t.addObject((ACSObject)bundle);
                            }
                            newAutoCategories.add(categoryID);
                            if (!this.isVerbose) continue;
                            AutoCategorisation.out("autoASSIGN " + t + " to " + bundle);
                            continue;
                        }
                        oldAutoCategories.remove(categoryID);
                        if (!this.isVerbose) continue;
                        AutoCategorisation.out("already auto assigned " + t);
                        continue;
                    }
                    if (!this.isVerbose) continue;
                    AutoCategorisation.out("already manually assigned " + t);
                }
                Iterator iter = oldAutoCategories.iterator();
                while (iter.hasNext()) {
                    Category category = new Category((BigDecimal)iter.next());
                    if (this.persistChanges) {
                        category.removeChild((ACSObject)bundle);
                    }
                    if (!this.isVerbose) continue;
                    AutoCategorisation.out("removing oldAuto " + category + " from " + bundle);
                }
                if (!newAutoCategories.isEmpty()) {
                    cursor = ((DataAssociation)DomainServiceInterfaceExposer.get((DomainObject)bundle, (String)"categories")).cursor();
                    Filter f = cursor.addFilter("id IN :newAutoCats");
                    f.set("newAutoCats", newAutoCategories);
                    while (cursor.next()) {
                        Object categoryID = cursor.get("id");
                        if (this.persistChanges) {
                            DataObject link = cursor.getLink();
                            link.set("isAuto", (Object)Boolean.TRUE);
                        }
                        if (!this.isVerbose) continue;
                        AutoCategorisation.out("isAuto=TRUE for new categoryID=" + categoryID + "/" + bundle);
                    }
                }
            }
        }

        private void assignKeywords() {
            if (this.item != null && !this.keywords.isEmpty()) {
                String dcKeywords;
                DublinCoreItem dcItem = DublinCoreItem.findByOwner((ContentItem)this.item);
                if (dcItem != null && (dcKeywords = dcItem.getKeywords()) != null) {
                    StringTokenizer tok = new StringTokenizer(dcKeywords, ";");
                    while (tok.hasMoreTokens()) {
                        this.keywords.add(tok.nextToken().trim());
                    }
                }
                StringBuffer buf = new StringBuffer();
                Iterator i = this.keywords.iterator();
                if (i.hasNext()) {
                    buf.append(i.next());
                }
                while (i.hasNext()) {
                    buf.append(';').append(' ').append(i.next());
                }
                String dcKeywords2 = buf.toString();
                if (this.isVerbose) {
                    AutoCategorisation.out("ASSIGN DC keywords \"" + dcKeywords2 + "\"");
                }
                if (this.persistChanges) {
                    if (dcItem == null) {
                        dcItem = DublinCoreItem.create((ContentItem)this.item);
                    }
                    dcItem.setKeywords(dcKeywords2);
                }
            }
        }
    }
}

