/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.aplaws;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.RootCategoryCollection;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ui.role.RoleFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Role;
import com.arsdigita.kernel.RoleCollection;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.london.terms.Domain;
import com.arsdigita.london.terms.importer.Parser;
import com.arsdigita.navigation.Template;
import com.arsdigita.navigation.TemplateMapping;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.parameter.BooleanParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringParameter;
import com.arsdigita.util.parameter.URLParameter;
import com.arsdigita.web.Application;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Loader
extends PackageLoader {
    private static final Logger s_log = Logger.getLogger(Loader.class);
    private static final String[] s_esdFiles = new String[]{"bundle/esd-toolkit/domain-gcl-2.10.xml", "bundle/esd-toolkit/domain-lgcl-1.04.xml", "bundle/esd-toolkit/domain-lgdl-2.01.xml", "bundle/esd-toolkit/domain-lgil-0.01.xml", "bundle/esd-toolkit/domain-lgsl-2.01.xml", "bundle/esd-toolkit/domain-lgal-0.01.xml", "bundle/esd-toolkit/hierarchy-lgcl-1.04.xml", "bundle/esd-toolkit/hierarchy-lgdl-2.01-lgsl-2.01.xml", "bundle/esd-toolkit/hierarchy-lgdl-2.01.xml", "bundle/esd-toolkit/hierarchy-lgil-0.01.xml", "bundle/esd-toolkit/mapping-lgcl-1.04-gcl-2.10.xml", "bundle/esd-toolkit/mapping-lgcl-1.04-lgsl-2.01.xml", "bundle/esd-toolkit/mapping-lgsl-2.00-lgcl-1.04.xml", "bundle/esd-toolkit/related-lgcl-1.04.xml", "bundle/aplaws/domain-rss-1.00.xml", "bundle/aplaws/hierarchy-rss-1.00.xml", "bundle/aplaws/domain-nav-1.03.xml", "bundle/aplaws/hierarchy-nav-1.03.xml"};
    private static final String[] s_esdFilesLite = new String[]{"bundle/esd-toolkit/domain-gcl-2.10.xml", "bundle/esd-toolkit/domain-lgcl-lite-1.04.xml", "bundle/esd-toolkit/domain-lgdl-2.01.xml", "bundle/esd-toolkit/domain-lgil-0.01.xml", "bundle/esd-toolkit/domain-lgsl-2.01.xml", "bundle/esd-toolkit/domain-lgal-0.01.xml", "bundle/esd-toolkit/hierarchy-lgcl-lite-1.04.xml", "bundle/esd-toolkit/hierarchy-lgdl-2.01-lgsl-2.01.xml", "bundle/esd-toolkit/hierarchy-lgdl-2.01.xml", "bundle/esd-toolkit/hierarchy-lgil-0.01.xml", "bundle/esd-toolkit/mapping-lgcl-1.04-gcl-2.10.xml", "bundle/esd-toolkit/mapping-lgcl-1.04-lgsl-2.01.xml", "bundle/esd-toolkit/mapping-lgsl-2.00-lgcl-1.04.xml", "bundle/esd-toolkit/related-lgcl-1.04.xml", "bundle/aplaws/domain-rss-1.00.xml", "bundle/aplaws/hierarchy-rss-1.00.xml", "bundle/aplaws/domain-nav-1.03.xml", "bundle/aplaws/hierarchy-nav-1.03.xml"};
    private StringParameter m_servicesDomain = new StringParameter("com.arsdigita.aplaws.services_domain", 1, (Object)"LGDL");
    private StringParameter m_navigationDomain = new StringParameter("com.arsdigita.aplaws.navigation_domain", 1, (Object)"APLAWS-NAV");
    private StringParameter m_interactionDomain;
    private StringParameter m_subjectDomain = new StringParameter("com.arsdigita.aplaws.subject_domain", 1, (Object)"LGCL");
    private StringParameter m_rssDomain;
    private BooleanParameter m_liteLoad;
    private StringParameter m_customNavKey;
    private URLParameter m_customNavDomainURL;
    private StringParameter m_customNavPath;
    private StringParameter m_customNavUseContext;
    private StringParameter m_customNavTitle;
    private StringParameter m_customNavDesc;

    public Loader() {
        this.m_interactionDomain = new StringParameter("com.arsdigita.aplaws.subject_domain", 1, (Object)"LGIL");
        this.m_rssDomain = new StringParameter("com.arsdigita.aplaws.rss_domain", 1, (Object)"APLAWS-RSS");
        this.m_liteLoad = new BooleanParameter("com.arsdigita.aplaws.lite_load", 1, (Object)Boolean.FALSE);
        this.m_customNavKey = new StringParameter("com.arsdigita.aplaws.custom_nav_key", 1, (Object)"APLAWS-CUSTOM");
        try {
            this.m_customNavDomainURL = new URLParameter("com.arsdigita.aplaws.custom_nav_domain_url", 1, (Object)new URL("http://www.aplaws.org.uk/standards/custom/1.00/termslist.xml"));
        }
        catch (MalformedURLException ex) {
            throw new UncheckedWrapperException("Cannot parse url", (Throwable)ex);
        }
        this.m_customNavPath = new StringParameter("com.arsdigita.aplaws.custom_nav_path", 1, (Object)"local");
        this.m_customNavUseContext = new StringParameter("com.arsdigita.aplaws.custom_nav_use_context", 1, (Object)"local");
        this.m_customNavTitle = new StringParameter("com.arsdigita.aplaws.custom_nav_title", 1, (Object)"Local Custom Navigation");
        this.m_customNavDesc = new StringParameter("com.arsdigita.aplaws.custom_nav_desc", 1, (Object)"Installation specific custom navigation tree");
        this.register((Parameter)this.m_servicesDomain);
        this.register((Parameter)this.m_navigationDomain);
        this.register((Parameter)this.m_interactionDomain);
        this.register((Parameter)this.m_subjectDomain);
        this.register((Parameter)this.m_rssDomain);
        this.register((Parameter)this.m_liteLoad);
        this.register((Parameter)this.m_customNavDesc);
        this.register((Parameter)this.m_customNavDomainURL);
        this.register((Parameter)this.m_customNavKey);
        this.register((Parameter)this.m_customNavPath);
        this.register((Parameter)this.m_customNavTitle);
        this.register((Parameter)this.m_customNavUseContext);
    }

    public void run(ScriptContext ctx) {
        Application.createApplication((String)"com.arsdigita.navigation.Navigation", (String)"services", (String)"Services", null);
        String customNavPath = (String)this.get((Parameter)this.m_customNavPath);
        String customNavTitle = (String)this.get((Parameter)this.m_customNavTitle);
        Application.createApplication((String)"com.arsdigita.navigation.Navigation", (String)customNavPath, (String)customNavTitle, null);
        String[] files = Boolean.TRUE.equals(this.get((Parameter)this.m_liteLoad)) ? s_esdFilesLite : s_esdFiles;
        Parser parser = new Parser();
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Process " + file));
            }
            parser.parse(Thread.currentThread().getContextClassLoader().getResourceAsStream(file));
        }
        String navigationKey = (String)this.get((Parameter)this.m_navigationDomain);
        String interactionKey = (String)this.get((Parameter)this.m_interactionDomain);
        String servicesKey = (String)this.get((Parameter)this.m_servicesDomain);
        String subjectKey = (String)this.get((Parameter)this.m_subjectDomain);
        String rssKey = (String)this.get((Parameter)this.m_rssDomain);
        this.registerDomain(navigationKey, "/navigation/", null);
        this.registerDomain(navigationKey, "/content/", null);
        this.registerDomain(navigationKey, "/portal/", null);
        this.registerDomain(subjectKey, "/search/", null);
        this.registerDomain(subjectKey, "/content/", "subject");
        this.registerDomain(servicesKey, "/services/", null);
        this.registerDomain(servicesKey, "/content/", "services");
        this.registerDomain(rssKey, "/channels/", null);
        this.registerDomain(rssKey, "/content/", "rss");
        this.registerDomain(interactionKey, "/content/", "interaction");
        this.registerServicesTemplate("/services/");
        this.registerPortalTemplate();
        String customNavDesc = (String)this.get((Parameter)this.m_customNavDesc);
        String customNavKey = (String)this.get((Parameter)this.m_customNavKey);
        String customNavUseContext = (String)this.get((Parameter)this.m_customNavUseContext);
        URL customNavDomainURL = (URL)this.get((Parameter)this.m_customNavDomainURL);
        Domain.create((String)customNavKey, (URL)customNavDomainURL, (String)customNavTitle, (String)customNavDesc, (String)"1.0.0", (Date)new Date());
        this.registerDomain(customNavKey, '/' + customNavPath + '/', null);
        this.registerDomain(customNavKey, "/content/", customNavUseContext);
    }

    public void registerServicesTemplate(String appURL) {
        Application app = Application.retrieveApplicationForPath((String)appURL);
        Assert.exists((Object)app, Application.class);
        Category root = Category.getRootForObject((ACSObject)app);
        Assert.exists((Object)root, Category.class);
        Template template = Template.create((String)"APLAWS Services", (String)"APLAWS ESD Toolkit Services", (String)"/templates/ccm-navigation/navigation/aplaws-services.jsp");
        new TemplateMapping(template, root, "public", "default");
    }

    public void registerPortalTemplate() {
        Template template = Template.create((String)"APLAWS Portal", (String)"APLAWS Portal in category", (String)"/templates/ccm-navigation/navigation/aplaws-portal.jsp");
    }

    public void registerDomain(String domainKey, String appURL, String context) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Mapping domain " + domainKey + " to app " + appURL + " in context " + context));
        }
        Domain domain = Domain.retrieve((String)domainKey);
        Application app = Application.retrieveApplicationForPath((String)appURL);
        domain.setAsRootForObject((ACSObject)app, context);
        if (app instanceof ContentSection) {
            RoleCollection coll = ((ContentSection)app).getStaffGroup().getOrderedRoles();
            HashSet<Role> adminRoles = new HashSet<Role>();
            HashSet<Role> categorizeRoles = new HashSet<Role>();
            while (coll.next()) {
                Role role = coll.getRole();
                DataQuery privs = RoleFactory.getRolePrivileges((BigDecimal)app.getID(), (BigDecimal)role.getGroup().getID());
                while (privs.next()) {
                    String priv = (String)privs.get("privilege");
                    if (priv.equals("cms_category_admin")) {
                        adminRoles.add(role);
                        continue;
                    }
                    if (!priv.equals("cms_categorize_items")) continue;
                    categorizeRoles.add(role);
                }
            }
            RootCategoryCollection catCollection = Category.getRootCategories((ACSObject)((ContentSection)app));
            while (catCollection.next()) {
                Iterator adminIter = adminRoles.iterator();
                while (adminIter.hasNext()) {
                    ((Role)adminIter.next()).grantPermission((ACSObject)catCollection.getCategory(), PrivilegeDescriptor.ADMIN);
                }
                Iterator categorizeIter = categorizeRoles.iterator();
                while (categorizeIter.hasNext()) {
                    ((Role)categorizeIter.next()).grantPermission((ACSObject)catCollection.getCategory(), Category.MAP_DESCRIPTOR);
                }
            }
        }
    }
}

