/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.aplaws.ui;

import com.arsdigita.aplaws.AutoCategorisation;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.MultipleSelect;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.london.terms.Term;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedList;

public class AutoCategoryForm
extends Form {
    private MultipleSelect autoCatNames = new MultipleSelect("autoCatNames");
    private Hidden autoCatIDs = new Hidden((ParameterModel)new ArrayParameter((ParameterModel)new BigDecimalParameter("autoCatIDs")));
    private SaveCancelSection buttons = new SaveCancelSection();

    public AutoCategoryForm() {
        super("autocat", (Container)new BoxPanel(2));
        this.add((Component)new Label(new GlobalizedMessage("autocat.title", "com.arsdigita.aplaws.AplawsResources")));
        this.autoCatNames.setReadOnly();
        this.autoCatNames.setDisabled();
        this.add((Component)this.autoCatNames);
        this.add((Component)this.autoCatIDs);
        this.add((Component)this.buttons);
        this.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent e) throws FormProcessException {
                PageState state = e.getPageState();
                try {
                    ContentItem item = CMS.getContext().getContentItem();
                    Collection terms = AutoCategorisation.getAutoTerms(item);
                    LinkedList<BigDecimal> ids = new LinkedList<BigDecimal>();
                    for (Term t : terms) {
                        Category c = t.getModel();
                        ids.add(c.getID());
                        AutoCategoryForm.this.autoCatNames.addOption(new Option(c.getID().toString(), c.getQualifiedName(">", true)), state);
                    }
                    AutoCategoryForm.this.autoCatIDs.setValue(state, (Object)ids.toArray(new BigDecimal[ids.size()]));
                }
                catch (AutoCategorisation.ServiceFailed sf) {
                    AutoCategoryForm.this.autoCatNames.addOption(new Option("0", "FAILED: " + sf.getCause().getMessage()), state);
                }
            }
        });
        this.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) throws FormProcessException {
                PageState state = ev.getPageState();
                ContentItem item = CMS.getContext().getContentItem();
                ContentBundle bundle = (ContentBundle)item.getParent();
                BigDecimal[] ids = (BigDecimal[])AutoCategoryForm.this.autoCatIDs.getValue(state);
                for (int i = 0; i < ids.length; ++i) {
                    Category cat = (Category)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.categorization.Category", (Object)ids[i]));
                    cat.addChild((ACSObject)bundle);
                }
                AutoCategoryForm.this.fireCompletionEvent(state);
            }
        });
        this.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent ev) throws FormProcessException {
                PageState state = ev.getPageState();
                if (AutoCategoryForm.this.buttons.getCancelButton().isSelected(state)) {
                    AutoCategoryForm.this.fireCompletionEvent(state);
                    throw new FormProcessException("cancelled");
                }
            }
        });
    }
}

