/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bundle.ui;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitTab;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.navigation.ui.AbstractComponent;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GenericOrgaUnitTabComponent
extends AbstractComponent {
    private Page page;
    private OID orgaunitOid;
    private GenericOrgaUnitTab tab;

    public void setPage(Page page) {
        this.page = page;
    }

    public void setOrgaUnit(String oid) {
        this.orgaunitOid = OID.valueOf((String)oid);
    }

    public void setOrgaUnitTab(GenericOrgaUnitTab tab) {
        this.tab = tab;
    }

    public Element generateXML(HttpServletRequest request, HttpServletResponse response) {
        PageState state;
        try {
            state = new PageState(this.page, request, response);
        }
        catch (ServletException ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
        GenericOrganizationalUnit orgaunit = (GenericOrganizationalUnit)DomainObjectFactory.newInstance((OID)this.orgaunitOid);
        if (!orgaunit.getLanguage().equals(GlobalizationHelper.getNegotiatedLocale().getLanguage())) {
            orgaunit = (GenericOrganizationalUnit)orgaunit.getContentBundle().getInstance(GlobalizationHelper.getNegotiatedLocale());
        }
        if (DispatcherHelper.getDispatcherPrefix((HttpServletRequest)request) == null || !DispatcherHelper.getDispatcherPrefix((HttpServletRequest)request).equals("preview")) {
            orgaunit = (GenericOrganizationalUnit)orgaunit.getLiveVersion();
        }
        Element contentPanelElem = new Element("cms:contentPanel", "http://www.arsdigita.com/cms/1.0");
        Element cmsItemElem = contentPanelElem.newChildElement("cms:item", "http://www.arsdigita.com/cms/1.0");
        cmsItemElem.addAttribute("oid", this.orgaunitOid.toString());
        Element objTypeElem = cmsItemElem.newChildElement("objectType");
        objTypeElem.setText(orgaunit.getClass().getName());
        Element tabsElem = contentPanelElem.newChildElement("orgaUnitTabs");
        Element selectedTabElem = tabsElem.newChildElement("selectedTab");
        if (orgaunit != null) {
            this.tab.generateXml(orgaunit, selectedTabElem, state);
        }
        return contentPanelElem;
    }
}

