/*
 * Decompiled with CFR 0.152.
 */
package org.undp.weblog;

import com.arsdigita.db.DbHelper;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.pdl.ManifestSource;
import com.arsdigita.persistence.pdl.NameFilter;
import com.arsdigita.persistence.pdl.PDLFilter;
import com.arsdigita.persistence.pdl.PDLSource;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.DomainInitEvent;
import com.arsdigita.runtime.PDLInitializer;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.ui.admin.ApplicationManagers;
import com.arsdigita.ui.admin.applications.ApplicationManager;
import org.apache.log4j.Logger;
import org.undp.weblog.WebLogAppManager;
import org.undp.weblog.WebLogApplication;
import org.undp.weblog.ui.WebLogPortlet;

public class Initializer
extends CompoundInitializer {
    private static final Logger s_log = Logger.getLogger(Initializer.class);

    public Initializer() {
        String url = RuntimeConfig.getConfig().getJDBCURL();
        int database = DbHelper.getDatabaseFromURL((String)url);
        this.add((com.arsdigita.runtime.Initializer)new PDLInitializer((PDLSource)new ManifestSource("ccm-weblog.pdl.mf", (PDLFilter)new NameFilter(DbHelper.getDatabaseSuffix((int)database), "pdl"))));
    }

    public void init(DomainInitEvent e) {
        s_log.info((Object)"WebLog Initializer starting.");
        super.init(e);
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)WebLogApplication.BASE_DATA_OBJECT_TYPE, (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new WebLogApplication(dataObject);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)WebLogPortlet.BASE_DATA_OBJECT_TYPE, (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new WebLogPortlet(dataObject);
            }
        });
        ApplicationManagers.register((ApplicationManager)new WebLogAppManager());
        s_log.debug((Object)"WebLog Initializer done.");
    }
}

